/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.ShopBuyLimitTypeEnum;
import com.handy.guild.constants.ShopSearchEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildShop;
import com.handy.guild.enter.GuildShopLog;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildShopLogService;
import com.handy.guild.service.GuildShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildShopGui {
    private static final GuildShopGui INSTANCE = new GuildShopGui();

    private GuildShopGui() {
    }

    public static GuildShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id, String searchType) {
        String title = ConfigUtil.SHOP_CONFIG.getString("title");
        if (ShopSearchEnum.SYSTEM.getType().equals(searchType)) {
            title = ConfigUtil.SHOP_CONFIG.getString("systemTitle");
        }
        if (ShopSearchEnum.PLAYER.getType().equals(searchType)) {
            title = ConfigUtil.SHOP_CONFIG.getString("playerTitle");
        }
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        handyInventory.setSearchType(searchType);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        String searchType = handyInventory.getSearchType();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        ArrayList<Integer> guildInfoIds = new ArrayList<Integer>();
        if (ShopSearchEnum.ALL.getType().equals(searchType)) {
            guildInfoIds.add(0);
            guildInfoIds.add(handyInventory.getId());
        }
        if (ShopSearchEnum.SYSTEM.getType().equals(searchType)) {
            guildInfoIds.add(0);
        }
        if (ShopSearchEnum.PLAYER.getType().equals(searchType)) {
            guildInfoIds.add(handyInventory.getId());
        }
        Page<GuildShop> page = GuildShopService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize(), guildInfoIds);
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Integer level = guildInfo.getLevel();
        Integer money = guildPlayer.getMoney();
        List<GuildShop> records = page.getRecords();
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (GuildShop record : records) {
            Integer index = guiIndexList.get(i++);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(record.getItemStack());
            List loreList = ConfigUtil.SHOP_CONFIG.getStringList("logo.guild");
            List lore = ItemStackUtil.getItemMeta(itemStack).getLore();
            if (CollUtil.isNotEmpty(lore)) {
                lore.addAll(loreList);
                loreList = lore;
            }
            if (StrUtil.isNotEmpty(record.getPlayerName())) {
                List sellList = ConfigUtil.SHOP_CONFIG.getStringList("logo.sell");
                loreList.addAll(sellList);
            }
            List<String> newLoreList = ItemStackUtil.loreReplaceMap(loreList, this.replaceMap(money, record, level, player));
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setLore(BaseUtil.replaceChatColor(newLoreList));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, record.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "pane");
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "search", this.getSearchMap(handyInventory));
        int roleLimit = ConfigUtil.SHOP_CONFIG.getInt("sell.roleLimit", 2);
        if (guildPlayer.getRoleId() <= roleLimit) {
            HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "sell");
        }
    }

    private Map<String, String> getSearchMap(HandyInventory handyInventory) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(2);
        String searchType = handyInventory.getSearchType();
        String system = ConfigUtil.SHOP_CONFIG.getString("search.system");
        String player = ConfigUtil.SHOP_CONFIG.getString("search.player");
        String all = ConfigUtil.SHOP_CONFIG.getString("search.all");
        if (ShopSearchEnum.ALL.getType().equals(searchType)) {
            replaceMap.put("type", all);
            replaceMap.put("nextType", system);
        }
        if (ShopSearchEnum.SYSTEM.getType().equals(searchType)) {
            replaceMap.put("type", system);
            replaceMap.put("nextType", player);
        }
        if (ShopSearchEnum.PLAYER.getType().equals(searchType)) {
            replaceMap.put("type", player);
            replaceMap.put("nextType", all);
        }
        return replaceMap;
    }

    private Map<String, String> replaceMap(Integer money, GuildShop guildShop, Integer guildLevel, Player player) {
        Integer price = guildShop.getPrice();
        Integer level = guildShop.getLevel();
        Integer number = guildShop.getNumber();
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(6);
        String button = ConfigUtil.SHOP_CONFIG.getString("noButton");
        if (money >= price) {
            button = number == 0 ? ConfigUtil.SHOP_CONFIG.getString("yesButton") : this.buyLimit(guildShop, player);
        }
        if (level > guildLevel) {
            button = ConfigUtil.SHOP_CONFIG.getString("levelButton", "${level}").replace("${level}", level.toString());
        }
        if (StrUtil.isNotEmpty(guildShop.getPlayerName()) && player.getName().equals(guildShop.getPlayerName())) {
            button = ConfigUtil.SHOP_CONFIG.getString("noSell", "");
        }
        String unlimited = ConfigUtil.SHOP_CONFIG.getString("unlimited", "&a\u65e0\u9650\u5236");
        map.put("price", price.toString());
        map.put("level", level.toString());
        map.put("money", money.toString());
        map.put("number", number == 0 ? unlimited : number.toString());
        map.put("button", button);
        map.put("playerName", guildShop.getPlayerName());
        return map;
    }

    private String buyLimit(GuildShop guildShop, Player player) {
        int num = 0;
        ShopBuyLimitTypeEnum typeEnum = ShopBuyLimitTypeEnum.getEnumDefaultOnly(guildShop.getType());
        switch (typeEnum) {
            case ONLY: {
                Optional<GuildShopLog> guildShopLogOptional = GuildShopLogService.getInstance().findByPlayerName(player.getName(), typeEnum.getName(), guildShop.getId());
                num = guildShopLogOptional.isPresent() ? guildShopLogOptional.get().getNumber() : 0;
                break;
            }
            case DAY: {
                num = GuildShopLogService.getInstance().findCountByPlayerName(player.getName(), typeEnum.getName(), guildShop.getId(), DateUtil.getToday(), DateUtil.getTodayEnd());
                break;
            }
            case WEEK: {
                num = GuildShopLogService.getInstance().findCountByPlayerName(player.getName(), typeEnum.getName(), guildShop.getId(), DateUtil.getMonday(), DateUtil.getSunday());
                break;
            }
            case MONTH: {
                num = GuildShopLogService.getInstance().findCountByPlayerName(player.getName(), typeEnum.getName(), guildShop.getId(), DateUtil.getFirstDayOfMonth(), DateUtil.getLastDayOfMonth());
                break;
            }
        }
        String button = guildShop.getNumber() > num ? ConfigUtil.SHOP_CONFIG.getString("limitButton", "").replace("${number}", guildShop.getNumber() - num + "").replace("${buyType}", ShopBuyLimitTypeEnum.getTypeName(typeEnum)) : ConfigUtil.SHOP_CONFIG.getString("noLimitButton", "").replace("${buyType}", ShopBuyLimitTypeEnum.getTypeName(typeEnum));
        return button;
    }
}

