/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@HandyListener
public class PlayerCommandPreprocessEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!ConfigUtil.KIT_PVP_CONFIG.getBoolean("disabledCommand", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isOp()) {
            return;
        }
        String message = event.getMessage();
        if ((message = message.replace("/", "")).isEmpty()) {
            return;
        }
        String[] messageList = message.split(" ");
        String command = messageList[0];
        List whiteCommandList = ConfigUtil.KIT_PVP_CONFIG.getStringList("whiteCommand");
        if (CollUtil.isNotEmpty(whiteCommandList)) {
            for (String whiteCommand : whiteCommandList) {
                if (StrUtil.isEmpty(whiteCommand)) continue;
                if (message.equalsIgnoreCase(whiteCommand)) {
                    return;
                }
                if (!command.equalsIgnoreCase(whiteCommand)) continue;
                return;
            }
        }
        this.match(event);
        this.season(event);
    }

    private void match(PlayerCommandPreprocessEvent event) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        if (MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(event.getPlayer().getUniqueId()) == null) {
            return;
        }
        event.setCancelled(true);
        MessageUtil.sendMessage(event.getPlayer(), ConfigUtil.KIT_PVP_CONFIG.getString("disabledCommandMsg"));
    }

    private void season(PlayerCommandPreprocessEvent event) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        if (SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(event.getPlayer().getUniqueId()) == null) {
            return;
        }
        event.setCancelled(true);
        MessageUtil.sendMessage(event.getPlayer(), ConfigUtil.KIT_PVP_CONFIG.getString("disabledCommandMsg"));
    }
}

