/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.command.function.AcceptCommand;
import com.handy.guild.command.function.DenyCommand;
import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.inventory.GuildApplyGui;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.util.ConfigUtil;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildApplyClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_APPLY.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        int backIndex = ConfigUtil.APPLY_CONFIG.getInt("back.index");
        if (rawSlot == backIndex) {
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.APPLY_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildApplyGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.APPLY_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildApplyGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Integer applyId = map.get(rawSlot);
        if (applyId == null) {
            return;
        }
        if (ClickType.RIGHT.equals((Object)event.getClick())) {
            DenyCommand.deny(player, applyId);
        } else {
            AcceptCommand.accept(player, applyId);
        }
        GuildApplyGui.getInstance().setInventoryDate(handyInventory);
    }
}

