/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildCreateWorldClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_WORLD_CREATE.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_WORLD_CONFIG, "back")) {
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        boolean rst = false;
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_WORLD_CONFIG, "point")) {
            int pointPrice = ConfigUtil.CREATE_WORLD_CONFIG.getInt("point.price");
            rst = PlayerPointsUtil.buy(player, pointPrice);
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_WORLD_CONFIG, "vault")) {
            int vaultPrice = ConfigUtil.CREATE_WORLD_CONFIG.getInt("vault.price");
            rst = VaultUtil.buy(player, vaultPrice);
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_WORLD_CONFIG, "money")) {
            int moneyPrice = ConfigUtil.CREATE_WORLD_CONFIG.getInt("money.price");
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            Integer money = guildInfo.getMoney();
            if (money < moneyPrice) {
                rst = false;
            } else {
                GuildInfoService.getInstance().subtractMoneyById(guildId, moneyPrice);
                rst = true;
            }
        }
        if (!rst) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_WORLD_CONFIG.getString("notMoneyFailureMsg"));
            return;
        }
        handyInventory.syncClose();
        PlayerSchedulerUtil.syncPerformCommand(player, "plg createWorld");
    }
}

