/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.match;

import com.handy.guild.PlayerGuild;
import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.event.GuildPvpMatchEvent;
import com.handy.guild.inventory.GuildActivityGui;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.expand.adapter.HandyRunnable;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.param.BcMessageParam;
import com.handy.guild.lib.util.BcUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@HandyListener
public class GuildPvpMatchListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onGuildPvpMatching(GuildPvpMatchEvent event) {
        this.match(event);
    }

    private synchronized void match(GuildPvpMatchEvent event) {
        if (MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.get(event.getGuildId()) != null) {
            return;
        }
        MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.put(event.getGuildId(), 0);
        this.matchPvpTask(event.getGuildId(), event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onGuildPvpMatchingMsg(GuildPvpMatchEvent event) {
        String range = ConfigUtil.ACTIVITY_CONFIG.getString("mateNotice.range", "not");
        if ("not".equalsIgnoreCase(range)) {
            return;
        }
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            Integer guildId = event.getGuildId();
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            String msg = ConfigUtil.ACTIVITY_CONFIG.getString("mateNotice.msg", "").replace("${guildName}", guildInfo.getGuildName());
            if ("op".equalsIgnoreCase(range)) {
                for (OfflinePlayer operator : Bukkit.getOperators()) {
                    MessageUtil.sendMessage(operator.getUniqueId(), msg);
                }
                return;
            }
            if ("all".equalsIgnoreCase(range)) {
                MessageUtil.sendAllMessage(msg);
                BcMessageParam bcMessageParam = new BcMessageParam();
                bcMessageParam.setPluginName(PlayerGuild.INSTANCE.getName());
                bcMessageParam.setType("guild_match");
                bcMessageParam.setMessage(msg);
                BcUtil.sendParamForward(event.getPlayer(), bcMessageParam);
            }
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onGuildPvpMatchingButton(GuildPvpMatchEvent event) {
        if (event.getHandyInventory() != null) {
            GuildActivityGui.getInstance().matePvpButtonTask(event.getHandyInventory());
        }
    }

    private void matchPvpTask(final Integer guildId, final Player player) {
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                Integer number = MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.get(guildId);
                if (number == null) {
                    this.cancel();
                    return;
                }
                if ((number = Integer.valueOf(number + 1)) > 300) {
                    MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.remove(guildId);
                    MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("mateNoMsg"));
                    this.cancel();
                    return;
                }
                MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.put(guildId, number);
                if (MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.size() < 2) {
                    return;
                }
                if (!MatchConstants.GUILD_PVP_PREPARATION_MAP.isEmpty()) {
                    return;
                }
                ArrayList<Integer> guildLocationId = new ArrayList<Integer>();
                if (!MatchConstants.GUILD_PVP_START_LOCATION_MAP.isEmpty()) {
                    for (Integer guildId2 : MatchConstants.GUILD_PVP_START_LOCATION_MAP.keySet()) {
                        guildLocationId.add(MatchConstants.GUILD_PVP_START_LOCATION_MAP.get(guildId2));
                    }
                }
                List<Integer> startLocationIds = guildLocationId.stream().distinct().collect(Collectors.toList());
                List<GuildPvpLocation> guildPvpLocations = GuildPvpLocationService.getInstance().listByNotIds(GuildActivityType.MATCH.getType(), startLocationIds);
                if (CollUtil.isEmpty(guildPvpLocations)) {
                    return;
                }
                Iterator<Integer> iterator = MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.keySet().iterator();
                ArrayList<Integer> guildIdList = new ArrayList<Integer>();
                while (iterator.hasNext()) {
                    Integer guildId3 = iterator.next();
                    MatchConstants.GUILD_PVP_PREPARATION_MAP.put(guildId3, new ArrayList());
                    guildIdList.add(guildId3);
                    iterator.remove();
                    if (guildIdList.size() != 2) continue;
                    GuildUtil.callGuildPvpPreparationEvent(guildIdList);
                    return;
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 1L, 20L);
    }
}

