/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildLogo;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import java.util.List;
import java.util.Optional;

public class GuildLogoService {
    private GuildLogoService() {
    }

    public static GuildLogoService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildLogo guildLogo) {
        return Db.use(GuildLogo.class).execution().insert(guildLogo);
    }

    public Page<GuildLogo> page(Integer guildInfoId, Integer pageNum, Integer pageSize) {
        Db<GuildLogo> db = Db.use(GuildLogo.class);
        db.where().eq(GuildLogo::getGuildInfoId, guildInfoId).limit(pageNum, pageSize).orderByDesc(GuildLogo::getId);
        return db.execution().page();
    }

    public List<GuildLogo> list(Integer guildInfoId) {
        Db<GuildLogo> db = Db.use(GuildLogo.class);
        db.where().eq(GuildLogo::getGuildInfoId, guildInfoId).orderByDesc(GuildLogo::getId);
        return db.execution().list();
    }

    public Optional<GuildLogo> findById(Integer id) {
        return Db.use(GuildLogo.class).execution().selectById(id);
    }

    public void updateUseToFalse(Integer guildInfoId) {
        Db<GuildLogo> use = Db.use(GuildLogo.class);
        use.where().eq(GuildLogo::getGuildInfoId, guildInfoId);
        use.update().set(GuildLogo::getUseFlag, false);
        use.execution().update();
    }

    public void updateUseById(Integer id) {
        Db<GuildLogo> use = Db.use(GuildLogo.class);
        use.update().set(GuildLogo::getUseFlag, true);
        use.execution().updateById(id);
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildLogo> use = Db.use(GuildLogo.class);
        use.where().eq(GuildLogo::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildLogo> findAll() {
        return Db.use(GuildLogo.class).execution().list();
    }

    public void updateLogoName(Integer id, String logoName) {
        Db<GuildLogo> use = Db.use(GuildLogo.class);
        use.update().set(GuildLogo::getLogoName, logoName);
        use.execution().updateById(id);
    }

    public void updateLogoNameByLogoId(Integer logoId, String logoName) {
        Db<GuildLogo> use = Db.use(GuildLogo.class);
        use.update().set(GuildLogo::getLogoName, logoName);
        use.where().eq(GuildLogo::getLogoId, logoId);
        use.execution().update();
    }

    public void delByLogoId(Integer logoId) {
        Db<GuildLogo> use = Db.use(GuildLogo.class);
        use.where().eq(GuildLogo::getLogoId, logoId);
        use.execution().delete();
    }

    private static class SingletonHolder {
        private static final GuildLogoService INSTANCE = new GuildLogoService();

        private SingletonHolder() {
        }
    }
}

