/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.util.GuildUtil;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class GuildPlayerService {
    private GuildPlayerService() {
    }

    public static GuildPlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildPlayer guildPlayer) {
        guildPlayer.setMoney(0);
        guildPlayer.setWeekMoney(0);
        guildPlayer.setTotalMoney(0);
        guildPlayer.setGuildMoney(0);
        guildPlayer.setOre(0);
        guildPlayer.setTotalOre(0);
        guildPlayer.setJoinTime(new Date());
        guildPlayer.setLastJoinTime(new Date());
        int rst = Db.use(GuildPlayer.class).execution().insert(guildPlayer);
        if (rst > 0) {
            GuildUtil.callPlayerJoinGuildEvent(guildPlayer.getPlayerName(), guildPlayer.getPlayerUuid(), guildPlayer.getGuildInfoId());
        }
    }

    public Page<GuildPlayer> page(Integer guildInfoId, Integer pageNum, Integer pageSize) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.where().eq(GuildPlayer::getGuildInfoId, guildInfoId).limit(pageNum, pageSize).orderByDesc(GuildPlayer::getTotalMoney);
        return db.execution().page();
    }

    public Optional<GuildPlayer> findByPlayerName(String playerName) {
        Db<GuildPlayer> playerDb = Db.use(GuildPlayer.class);
        playerDb.where().eq(GuildPlayer::getPlayerName, playerName);
        return playerDb.execution().selectOne();
    }

    public List<GuildPlayer> findByPlayerNameList(List<String> playerNameList) {
        Db<GuildPlayer> playerDb = Db.use(GuildPlayer.class);
        playerDb.where().in(GuildPlayer::getPlayerName, playerNameList);
        return playerDb.execution().list();
    }

    public List<GuildPlayer> findByPlayerUuids(List<String> playerUuids) {
        Db<GuildPlayer> playerDb = Db.use(GuildPlayer.class);
        playerDb.where().in(GuildPlayer::getPlayerUuid, playerUuids);
        return playerDb.execution().list();
    }

    public List<GuildPlayer> findByIdAndRoleIds(Integer id, List<Integer> roleIds) {
        Db<GuildPlayer> guildPlayerDb = Db.use(GuildPlayer.class);
        guildPlayerDb.where().eq(GuildPlayer::getGuildInfoId, id).in(GuildPlayer::getRoleId, roleIds);
        return guildPlayerDb.execution().list();
    }

    public Optional<GuildPlayer> findById(Integer id) {
        return Db.use(GuildPlayer.class).execution().selectById(id);
    }

    public List<GuildPlayer> findByGuildId(Integer guildId) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.where().eq(GuildPlayer::getGuildInfoId, guildId);
        return use.execution().list();
    }

    public Optional<GuildPlayer> findOneRoleByGuildId(Integer guildId) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.where().eq(GuildPlayer::getGuildInfoId, guildId).eq(GuildPlayer::getRoleId, GuildRoleEnum.ONE.getRoleId());
        return use.execution().selectOne();
    }

    public Optional<GuildPlayer> findOneTotalMoneyByGuildId(Integer guildId) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.where().eq(GuildPlayer::getGuildInfoId, guildId).orderByDesc(GuildPlayer::getTotalMoney).limit(1, 1);
        return use.execution().selectOne();
    }

    public List<GuildPlayer> findByGuildName(String guildName) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.where().eq(GuildPlayer::getGuildInfoName, guildName);
        return use.execution().list();
    }

    public List<GuildPlayer> findByGuildInfoIds(List<Integer> guildInfoIds) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.where().in(GuildPlayer::getGuildInfoId, guildInfoIds);
        return db.execution().list();
    }

    public List<GuildPlayer> findRoleByGuildInfoIds(List<Integer> guildInfoIds) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.where().in(GuildPlayer::getGuildInfoId, guildInfoIds).eq(GuildPlayer::getRoleId, GuildRoleEnum.ONE.getRoleId());
        return db.execution().list();
    }

    public void deleteById(Integer id) {
        Db<GuildPlayer> guildPlayerDb = Db.use(GuildPlayer.class);
        guildPlayerDb.execution().deleteById(id);
    }

    public void addMoneyById(Integer id, int money) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().add(GuildPlayer::getMoney, GuildPlayer::getMoney, money).add(GuildPlayer::getWeekMoney, GuildPlayer::getWeekMoney, money).add(GuildPlayer::getTotalMoney, GuildPlayer::getTotalMoney, money);
        db.execution().updateById(id);
    }

    public boolean addMoneyByName(String playerName, int money) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().add(GuildPlayer::getMoney, GuildPlayer::getMoney, money).add(GuildPlayer::getWeekMoney, GuildPlayer::getWeekMoney, money).add(GuildPlayer::getTotalMoney, GuildPlayer::getTotalMoney, money);
        db.where().eq(GuildPlayer::getPlayerName, playerName);
        return db.execution().update() > 0;
    }

    public void subtractMoneyById(Integer id, int money) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().subtract(GuildPlayer::getMoney, GuildPlayer::getMoney, money);
        db.execution().updateById(id);
    }

    public void addGuildMoneyById(Integer id, int money) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().add(GuildPlayer::getGuildMoney, GuildPlayer::getGuildMoney, money);
        db.execution().updateById(id);
    }

    public boolean subtractMoneyByName(String playerName, int money) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().subtract(GuildPlayer::getMoney, GuildPlayer::getMoney, money);
        db.where().eq(GuildPlayer::getPlayerName, playerName);
        return db.execution().update() > 0;
    }

    public boolean setMoneyByName(String playerName, int money) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getMoney, money);
        db.where().eq(GuildPlayer::getPlayerName, playerName);
        return db.execution().update() > 0;
    }

    public void editPlayerGuildName(Integer guildId, String guildName) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.update().set(GuildPlayer::getGuildInfoName, guildName);
        use.where().eq(GuildPlayer::getGuildInfoId, guildId);
        use.execution().update();
    }

    public void editPlayerPvpStatus(Integer guildId, boolean pvpStatus) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.update().set(GuildPlayer::getPvpStatus, pvpStatus);
        use.where().eq(GuildPlayer::getGuildInfoId, guildId);
        use.execution().update();
        List<GuildPlayer> guildPlayerList = this.findByGuildId(guildId);
        for (GuildPlayer guildPlayer : guildPlayerList) {
            UUID uuid = UUID.fromString(guildPlayer.getPlayerUuid());
            if (!GuildConstants.PLAYER_GUILD_MAP.containsKey(uuid)) continue;
            GuildConstants.PLAYER_GUILD_MAP.put(uuid, guildPlayer);
        }
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildPlayer> use = Db.use(GuildPlayer.class);
        use.where().eq(GuildPlayer::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public void updateRoleIdById(Integer id, int roleId) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getRoleId, roleId);
        db.execution().updateById(id);
    }

    public void updateLastJoinTimeByPlayerName(String playerName, Date lastJoinTime) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getLastJoinTime, lastJoinTime);
        db.where().eq(GuildPlayer::getPlayerName, playerName);
        db.execution().update();
    }

    public void updateOre() {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getOre, 0).set(GuildPlayer::getTotalOre, 0);
        db.where().isNull(GuildPlayer::getOre);
        db.execution().update();
    }

    public void updateLastQuitTimeByPlayerName(String playerName, Date lastQuitTime) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getLastQuitTime, lastQuitTime);
        db.where().eq(GuildPlayer::getPlayerName, playerName);
        db.execution().update();
    }

    public List<GuildPlayer> findAll() {
        return Db.use(GuildPlayer.class).execution().list();
    }

    public void setPickaxeTime(String playerName, Date pickaxeTime, Integer ore) {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getPickaxeTime, pickaxeTime).set(GuildPlayer::getOre, ore).add(GuildPlayer::getTotalOre, GuildPlayer::getTotalOre, ore);
        db.where().eq(GuildPlayer::getPlayerName, playerName);
        db.execution().update();
    }

    public int clearWeekMoney() {
        Db<GuildPlayer> db = Db.use(GuildPlayer.class);
        db.update().set(GuildPlayer::getWeekMoney, 0);
        return db.execution().update();
    }

    private static class SingletonHolder {
        private static final GuildPlayerService INSTANCE = new GuildPlayerService();

        private SingletonHolder() {
        }
    }
}

