/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.event.PlayerTaskScheduleEvent;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.constants.BaseConstants;
import com.handy.playertask.lib.constants.VersionCheckEnum;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class BlockBreakEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        if (itemInHand == null || Material.AIR.equals((Object)itemInHand.getType())) {
            return;
        }
        int enchantmentLevel = itemInHand.getEnchantmentLevel(Enchantment.SILK_TOUCH);
        if (enchantmentLevel > 0) {
            return;
        }
        Block block = event.getBlock();
        MessageUtil.sendDebugMessage(player, "\u60a8\u7834\u574f\u4e86:" + block.getType().name());
        String content = this.specialTreatment(block);
        if (StrUtil.isEmpty(content)) {
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTaskScheduleEvent(player, DemandTypeEnum.BLOCK_BREAK.getType(), 1, content));
    }

    private String specialTreatment(Block block) {
        Ageable ageable;
        BlockData blockData;
        String content = block.getType().name();
        if ("POTATOES".equals(content)) {
            content = "POTATO";
        }
        if ("CARROTS".equals(content)) {
            content = "CARROT";
        }
        if ("BEETROOTS".equals(content)) {
            content = "BEETROOT";
        }
        if ("TORCHFLOWER_CROP".equals(content)) {
            content = "TORCHFLOWER";
        }
        if ("PITCHER_CROP".equals(content)) {
            content = "PITCHER_PLANT";
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (blockData = block.getBlockData()) instanceof Ageable && (ageable = (Ageable)blockData).getAge() != ageable.getMaximumAge()) {
            return null;
        }
        return content;
    }
}

