/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskPlayer;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.inventory.OpenGui;
import com.handy.playertask.inventory.RefreshGui;
import com.handy.playertask.inventory.ShopGui;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.reward.RewardStrategy;
import com.handy.playertask.service.TaskPlayerDemandService;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OpenClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.OPEN.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                OpenGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                OpenGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "refresh")) {
            int doneStatusTask;
            if (ConfigUtil.REFRESH_CONFIG.getBoolean("doneRefresh", true) && (doneStatusTask = TaskPlayerService.getInstance().findByDoneStatus(player.getUniqueId(), DateUtil.getToday())) > 0) {
                return;
            }
            Inventory inventory = RefreshGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "shop")) {
            Inventory inventory = ShopGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.OPEN_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            if ("[CLOSE]".equalsIgnoreCase(command)) {
                handyInventory.syncClose();
                return;
            }
            HandySchedulerUtil.runTask(() -> player.chat("/" + command.trim()));
            return;
        }
        this.doneTask(handyInventory, event);
    }

    private void doneTask(HandyInventory handyInventory, InventoryClickEvent event) {
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        Integer id = map.get(event.getRawSlot());
        if (id == null) {
            return;
        }
        Optional<TaskPlayer> taskPlayerOptional = TaskPlayerService.getInstance().findById(id);
        if (!taskPlayerOptional.isPresent()) {
            return;
        }
        TaskPlayer taskPlayer = taskPlayerOptional.get();
        if (taskPlayer.getStatus().booleanValue()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("isFinish"));
            return;
        }
        List<TaskPlayerDemand> taskPlayerDemands = taskPlayer.getTaskPlayerDemands();
        if (CollUtil.isEmpty(taskPlayerDemands)) {
            this.taskFinish(player, taskPlayer);
            OpenGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        boolean submitRst = this.submitTask(player, taskPlayerDemands);
        int num = 0;
        for (TaskPlayerDemand taskPlayerDemand : taskPlayerDemands) {
            if (taskPlayerDemand.getCompletionAmount() < taskPlayerDemand.getAmount()) continue;
            ++num;
        }
        if (num == taskPlayerDemands.size()) {
            this.taskFinish(player, taskPlayer);
            OpenGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (submitRst) {
            OpenGui.getInstance().setInventoryDate(handyInventory);
        }
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("notTaskFinish"));
    }

    private boolean submitTask(Player player, List<TaskPlayerDemand> taskPlayerDemands) {
        boolean returnRst = false;
        if (CollUtil.isEmpty(taskPlayerDemands)) {
            return false;
        }
        for (TaskPlayerDemand taskPlayerDemand : taskPlayerDemands) {
            ItemStack itemStack;
            if (!DemandTypeEnum.SUBMIT.getType().equals(taskPlayerDemand.getType()) || taskPlayerDemand.getCompletionAmount() >= taskPlayerDemand.getAmount() || (itemStack = ItemStackUtil.itemStackDeserialize(taskPlayerDemand.getItemStack())).getItemMeta() == null) continue;
            String displayName = BaseUtil.getDisplayName(itemStack);
            Boolean removeItemRst = ItemStackUtil.removeItem(player.getInventory(), itemStack, taskPlayerDemand.getAmount(), false);
            if (!removeItemRst.booleanValue()) {
                String submitFailureMsg = BaseUtil.getMsgNotColor("submitFailureMsg", "").replace("${item}", displayName);
                MessageUtil.sendMessage(player, submitFailureMsg);
                continue;
            }
            boolean rst = TaskPlayerDemandService.getInstance().updateCompletionAmount(taskPlayerDemand.getId(), taskPlayerDemand.getAmount());
            if (!rst) continue;
            taskPlayerDemand.setCompletionAmount(taskPlayerDemand.getCompletionAmount() + taskPlayerDemand.getAmount());
            String submitSucceedMsg = BaseUtil.getMsgNotColor("submitSucceedMsg", "").replace("${item}", displayName);
            MessageUtil.sendMessage(player, submitSucceedMsg);
            returnRst = true;
        }
        return returnRst;
    }

    private void taskFinish(Player player, TaskPlayer taskPlayer) {
        Boolean rst = TaskPlayerService.getInstance().updateById(taskPlayer.getId(), true);
        if (!rst.booleanValue()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("taskFinishFailure"));
            return;
        }
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("taskFinish"));
        RewardStrategy.getInstance().reward(player, taskPlayer.getTaskRewardsList());
    }
}

