/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle;

import com.handy.playertitle.hook.PlaceholderUtil;
import com.handy.playertitle.lib.InitApi;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.OldColorUtil;
import com.handy.playertitle.util.TitleTabUtil;
import dev.esophose.playerparticles.api.PlayerParticlesAPI;
import java.util.Arrays;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerTitle
extends JavaPlugin {
    private static PlayerTitle INSTANCE;
    public static Economy ECON;
    public static PlayerPoints PLAYER_POINTS;
    public static boolean SUPER_TRAILS_PRO;
    public static boolean SUPER_TRAILS;
    public static PlayerParticlesAPI PP_API;
    public static boolean USE_PAPI;

    public void onEnable() {
        INSTANCE = this;
        InitApi initApi = InitApi.getInstance(this);
        ConfigUtil.init();
        this.loadEconomy();
        this.loadPlaceholder();
        this.loadPlayerPoints();
        this.loadAttributePlus();
        this.loadAttributeSystem();
        this.loadSxAttribute();
        this.loadSuperTrails();
        this.loadMmoItems();
        this.loadPlayerParticles();
        List<String> lordList = Arrays.asList("", " ____  _                      _____ _ _   _      ", " |  _ \\| | __ _ _   _  ___ _ _|_   _(_) |_| | ___ ", " | |_) | |/ _` | | | |/ _ \\ '__|| | | | __| |/ _ \\", " |  __/| | (_| | |_| |  __/ |   | | | | |_| |  __/", " |_|   |_|\\__,_|\\__, |\\___|_|   |_| |_|\\__|_|\\___|", "                |___/                             ");
        for (String lord : lordList) {
            MessageUtil.sendConsoleMessage(ChatColor.DARK_AQUA + lord);
        }
        initApi.initCommand("com.handy.playertitle.command").initListener("com.handy.playertitle.listener").initClickEvent("com.handy.playertitle.listener.gui").enableSql("com.handy.playertitle.entity").checkVersion(ConfigUtil.CONFIG.getBoolean("isCheckUpdate"), "https://api.github.com/repos/handy-git/PlayerTitleVersions/releases/latest").addMetrics(6913);
        TitleTabUtil.init();
        OldColorUtil.init();
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u5df2\u6210\u529f\u8f7d\u5165\u670d\u52a1\u5668\uff01");
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "Author:handy MCBBS: https://www.mcbbs.net/thread-1004671-1-1.html");
    }

    public void onDisable() {
        InitApi.disable();
    }

    public static PlayerTitle getInstance() {
        return INSTANCE;
    }

    public static Economy getEconomy() {
        return ECON;
    }

    public static PlayerPoints getPlayerPoints() {
        return PLAYER_POINTS;
    }

    public void loadEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultFailureMsg"));
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultFailureMsg"));
            return;
        }
        ECON = (Economy)rsp.getProvider();
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultSucceedMsg"));
    }

    public void loadPlaceholder() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderUtil(this).register();
            USE_PAPI = true;
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("placeholderAPISucceedMsg"));
            return;
        }
        USE_PAPI = false;
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("placeholderAPIFailureMsg"));
    }

    private void loadPlayerPoints() {
        if (Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            Plugin plugin = this.getServer().getPluginManager().getPlugin("PlayerPoints");
            PLAYER_POINTS = (PlayerPoints)plugin;
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerPointsSucceedMsg"));
            return;
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerPointsFailureMsg"));
    }

    private void loadAttributePlus() {
        boolean attributePlus = Bukkit.getPluginManager().getPlugin("AttributePlus") != null;
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg(attributePlus ? "attributePlusSucceedMsg" : "attributePlusFailureMsg"));
    }

    private void loadAttributeSystem() {
        boolean attributeSystem = Bukkit.getPluginManager().getPlugin("AttributeSystem") != null;
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg(attributeSystem ? "attributeSystemSucceedMsg" : "attributeSystemFailureMsg"));
    }

    private void loadSxAttribute() {
        boolean sxAttribute;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("SX-Attribute");
        boolean bl = sxAttribute = plugin != null;
        if (sxAttribute) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("sxAttributeSucceedMsg"));
        } else {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("sxAttributeFailureMsg"));
        }
    }

    private void loadSuperTrails() {
        boolean superTrailsProRst;
        boolean superTrailsRst;
        boolean bl = superTrailsRst = Bukkit.getPluginManager().getPlugin("SuperTrails") != null;
        if (superTrailsRst) {
            SUPER_TRAILS = true;
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("superTrailsSucceedMsg"));
            return;
        }
        boolean bl2 = superTrailsProRst = Bukkit.getPluginManager().getPlugin("SuperTrailsPro") != null;
        if (superTrailsProRst) {
            SUPER_TRAILS_PRO = true;
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("superTrailsSucceedMsg"));
            return;
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("superTrailsFailureMsg"));
    }

    private void loadMmoItems() {
        try {
            boolean rst;
            boolean bl = rst = Bukkit.getPluginManager().getPlugin("MMOItems") != null;
            if (rst) {
                MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("mmoItemsSucceedMsg"));
            } else {
                MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("mmoItemsFailureMsg"));
            }
        }
        catch (Throwable throwable) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("mmoItemsFailureMsg"));
        }
    }

    private void loadPlayerParticles() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlayerParticles")) {
            PP_API = PlayerParticlesAPI.getInstance();
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerParticlesSucceedMsg"));
            return;
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerParticlesFailureMsg"));
    }
}

