/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.service.TitleRewardLogService;
import com.handy.playertitle.service.TitleRewardService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ClearCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "clear";
    }

    @Override
    public String permission() {
        return "playerTitle.clear";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "clear")) {
            case CLEAR_TITLE: {
                TitleBuffService.getInstance().removeAll();
                TitleCoinService.getInstance().removeAll();
                TitleListService.getInstance().removeAll();
                TitleParticleService.getInstance().removeAll();
                TitlePlayerService.getInstance().removeAll();
                TitleRewardLogService.getInstance().removeAll();
                TitleRewardService.getInstance().removeAll();
                break;
            }
            case CLEAR_PLAYER: {
                TitlePlayerService.getInstance().removeAll();
                TitleRewardLogService.getInstance().removeAll();
                TitleCoinService.getInstance().removeAll();
                break;
            }
            case CLEAR_BUFF: {
                TitleBuffService.getInstance().removeAll();
                break;
            }
            case CLEAR_PARTICLE: {
                TitleParticleService.getInstance().removeAll();
                break;
            }
            case CLEAR_REWARD: {
                TitleRewardService.getInstance().removeAll();
                TitleRewardLogService.getInstance().removeAll();
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
            }
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
    }
}

