/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.player;

import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.inventory.ShopGui;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.util.ConfigUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ShopCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "shop";
    }

    @Override
    public String permission() {
        return "playerTitle.shop";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        if (args.length > 1 && "custom".equals(args[1]) && ConfigUtil.SHOP_CONFIG.getBoolean("titleCustom.enable")) {
            TitleConstants.TITLE_CUSTOM_MAP.put(player.getUniqueId(), "titleCustom");
            MessageUtil.sendMessage(player, ConfigUtil.TITLE_CUSTOM_CONFIG.getString("customMsg"));
            return;
        }
        Inventory inventory = ShopGui.getInstance().createGui(player);
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

