/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.constants;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.lib.util.BaseUtil;
import dev.esophose.playerparticles.styles.DefaultStyles;
import dev.esophose.playerparticles.styles.ParticleStyle;
import java.util.ArrayList;
import java.util.List;

public enum DefaultStylesEnum {
    ARROWS("ARROWS", DefaultStyles.ARROWS, BaseUtil.getLangMsg("playerParticles.arrows")),
    BATMAN("BATMAN", DefaultStyles.BATMAN, BaseUtil.getLangMsg("playerParticles.batman")),
    BEAM("BEAM", DefaultStyles.BEAM, BaseUtil.getLangMsg("playerParticles.beam")),
    BLOCK_BREAK("BLOCK_BREAK", DefaultStyles.BLOCKBREAK, BaseUtil.getLangMsg("playerParticles.block_break")),
    BLOCK_PLACE("BLOCK_PLACE", DefaultStyles.BLOCKPLACE, BaseUtil.getLangMsg("playerParticles.block_place")),
    CELEBRATION("CELEBRATION", DefaultStyles.CELEBRATION, BaseUtil.getLangMsg("playerParticles.celebration")),
    CHAINS("CHAINS", DefaultStyles.CHAINS, BaseUtil.getLangMsg("playerParticles.chains")),
    COMPANION("COMPANION", DefaultStyles.COMPANION, BaseUtil.getLangMsg("playerParticles.companion")),
    CUBE("CUBE", DefaultStyles.CUBE, BaseUtil.getLangMsg("playerParticles.cube")),
    DEATH("DEATH", DefaultStyles.DEATH, BaseUtil.getLangMsg("playerParticles.death")),
    FEET("FEET", DefaultStyles.FEET, BaseUtil.getLangMsg("playerParticles.feet")),
    FISHING("FISHING", DefaultStyles.FISHING, BaseUtil.getLangMsg("playerParticles.fishing")),
    HALO("HALO", DefaultStyles.HALO, BaseUtil.getLangMsg("playerParticles.halo")),
    HURT("HURT", DefaultStyles.HURT, BaseUtil.getLangMsg("playerParticles.hurt")),
    ICO_SPHERE("ICO_SPHERE", DefaultStyles.ICOSPHERE, BaseUtil.getLangMsg("playerParticles.ico_sphere")),
    INVOCATION("INVOCATION", DefaultStyles.INVOCATION, BaseUtil.getLangMsg("playerParticles.invocation")),
    MOVE("MOVE", DefaultStyles.MOVE, BaseUtil.getLangMsg("playerParticles.move")),
    NORMAL("NORMAL", DefaultStyles.NORMAL, BaseUtil.getLangMsg("playerParticles.normal")),
    ORBIT("ORBIT", DefaultStyles.ORBIT, BaseUtil.getLangMsg("playerParticles.orbit")),
    OUTLINE("OUTLINE", DefaultStyles.OUTLINE, BaseUtil.getLangMsg("playerParticles.outline")),
    OVERHEAD("OVERHEAD", DefaultStyles.OVERHEAD, BaseUtil.getLangMsg("playerParticles.overhead")),
    POINT("POINT", DefaultStyles.POINT, BaseUtil.getLangMsg("playerParticles.point")),
    POPPER("POPPER", DefaultStyles.POPPER, BaseUtil.getLangMsg("playerParticles.popper")),
    PULSE("PULSE", DefaultStyles.PULSE, BaseUtil.getLangMsg("playerParticles.pulse")),
    QUAD_HELIX("QUAD_HELIX", DefaultStyles.QUADHELIX, BaseUtil.getLangMsg("playerParticles.quad_helix")),
    RINGS("RINGS", DefaultStyles.RINGS, BaseUtil.getLangMsg("playerParticles.rings")),
    SPHERE("SPHERE", DefaultStyles.SPHERE, BaseUtil.getLangMsg("playerParticles.sphere")),
    SPIN("SPIN", DefaultStyles.SPIN, BaseUtil.getLangMsg("playerParticles.spin")),
    SPIRAL("SPIRAL", DefaultStyles.SPIRAL, BaseUtil.getLangMsg("playerParticles.spiral")),
    SWORDS("SWORDS", DefaultStyles.SWORDS, BaseUtil.getLangMsg("playerParticles.swords")),
    TELEPORT("TELEPORT", DefaultStyles.TELEPORT, BaseUtil.getLangMsg("playerParticles.teleport")),
    THICK("THICK", DefaultStyles.THICK, BaseUtil.getLangMsg("playerParticles.thick")),
    TRAIL("TRAIL", DefaultStyles.TRAIL, BaseUtil.getLangMsg("playerParticles.trail")),
    TWINS("TWINS", DefaultStyles.TWINS, BaseUtil.getLangMsg("playerParticles.twins")),
    VORTEX("VORTEX", DefaultStyles.VORTEX, BaseUtil.getLangMsg("playerParticles.vortex")),
    WHIRL("WHIRL", DefaultStyles.WHIRL, BaseUtil.getLangMsg("playerParticles.whirl")),
    WHIRLWIND("WHIRLWIND", DefaultStyles.WHIRLWIND, BaseUtil.getLangMsg("playerParticles.whirlwind")),
    WINGS("WINGS", DefaultStyles.WINGS, BaseUtil.getLangMsg("playerParticles.wings"));

    private final String name;
    private final ParticleStyle particleStyle;
    private final String zhName;

    public static List<String> getEnum() {
        ArrayList<String> enumList = new ArrayList<String>();
        if (PlayerTitle.PP_API == null) {
            return enumList;
        }
        for (DefaultStylesEnum defaultStylesEnum : DefaultStylesEnum.values()) {
            enumList.add(defaultStylesEnum.getName());
        }
        return enumList;
    }

    public static String getZhName(String name) {
        for (DefaultStylesEnum defaultStylesEnum : DefaultStylesEnum.values()) {
            if (!defaultStylesEnum.getName().equalsIgnoreCase(name)) continue;
            return defaultStylesEnum.getZhName();
        }
        return "";
    }

    public static ParticleStyle getDefaultStyle(String name) {
        for (DefaultStylesEnum defaultStylesEnum : DefaultStylesEnum.values()) {
            if (!defaultStylesEnum.getName().equalsIgnoreCase(name)) continue;
            return defaultStylesEnum.getParticleStyle();
        }
        return DefaultStyles.NORMAL;
    }

    public String getName() {
        return this.name;
    }

    public ParticleStyle getParticleStyle() {
        return this.particleStyle;
    }

    public String getZhName() {
        return this.zhName;
    }

    private DefaultStylesEnum(String name, ParticleStyle particleStyle, String zhName) {
        this.name = name;
        this.particleStyle = particleStyle;
        this.zhName = zhName;
    }
}

