/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AdminShopGui {
    private static final AdminShopGui INSTANCE = new AdminShopGui();

    private AdminShopGui() {
    }

    public static AdminShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.ADMIN_SHOP_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.ADMIN_SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.ADMIN_SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.ADMIN_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findTitleById(handyInventory.getId());
        if (!titleListOptional.isPresent()) {
            return;
        }
        TitleList titleList = titleListOptional.get();
        Map<String, String> replaceMap = this.getReplaceMap(titleList, handyInventory.getPlayer());
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "delete");
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "status", replaceMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "name", replaceMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "buyType", replaceMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "item", replaceMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "price", replaceMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "day", replaceMap);
        HashMap<String, List<String>> replaceBatchMap = MapUtil.newHashMapWithExpectedSize(3);
        String guiDelete = BaseUtil.getLangMsg("guiDelete");
        String guiManage = BaseUtil.getLangMsg("guiManage");
        List<String> description = TitleUtil.getDescription(titleList.getDescription());
        if (StrUtil.isNotEmpty(titleList.getDescription())) {
            description.add(" ");
            description.add(guiDelete);
        }
        replaceBatchMap.put("description", description);
        List<String> buff = TitleUtil.getBuff(titleList.getTitleBuffs());
        if (CollUtil.isNotEmpty(titleList.getTitleBuffs())) {
            buff.add(" ");
            buff.add(guiManage);
        }
        replaceBatchMap.put("buff", buff);
        List<String> particle = TitleUtil.getParticle(titleList.getTitleParticle());
        if (titleList.getTitleParticle() != null) {
            particle.add(" ");
            particle.add(guiDelete);
        }
        replaceBatchMap.put("particle", particle);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "buff", null, replaceBatchMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "particle", null, replaceBatchMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "description", null, replaceBatchMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "pane");
        int haveCount = TitlePlayerService.getInstance().findCount(titleList.getId());
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "player", MapUtil.of("number", String.valueOf(haveCount)));
    }

    private Map<String, String> getReplaceMap(TitleList titleList, Player player) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(8);
        map.put("buyType", BaseUtil.getLangMsg("buyType." + titleList.getBuyType()));
        String titleName = PlaceholderApiUtil.set(player, titleList.getTitleName());
        map.put("titleName", titleName);
        map.put("price", titleList.getAmount().toString());
        map.put("id", titleList.getId().toString());
        map.put("status", ConfigUtil.VIEW_SHOP_CONFIG.getString(titleList.getIsHide() != false ? "hide" : "show"));
        map.put("day", titleList.getDay() != 0 ? titleList.getDay() + BaseUtil.getLangMsg("shop.day") : BaseUtil.getLangMsg("perpetual"));
        map.put("item", BaseUtil.getLangMsg("not"));
        if (titleList.getBuyType().equals(BuyTypeEnum.ITEM_STACK.getBuyType())) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleList.getItemStack());
            map.put("item", BaseUtil.getDisplayName(ItemStackUtil.getItemMeta(itemStack).getDisplayName(), itemStack.getType().toString()));
        }
        if (titleList.getBuyType().equals(BuyTypeEnum.PERMISSION.getBuyType())) {
            map.put("item", titleList.getItemStack());
        }
        return map;
    }
}

