/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HavePlayerGui {
    private static final HavePlayerGui INSTANCE = new HavePlayerGui();

    private HavePlayerGui() {
    }

    public static HavePlayerGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.ADMIN_SHOP_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.ADMIN_SHOP_CONFIG.getInt("size", 54);
        title = BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, title));
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.ADMIN_SHOP_PLAYER.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.ADMIN_SHOP_PLAYER.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> intMap = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.ADMIN_SHOP_CONFIG.getString("playerView.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TitlePlayer> page = TitlePlayerService.getInstance().pageByTitleId(handyInventory.getId(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String name = ConfigUtil.ADMIN_SHOP_CONFIG.getString("playerView.name");
        String material = ConfigUtil.ADMIN_SHOP_CONFIG.getString("playerView.material");
        List loreList = ConfigUtil.ADMIN_SHOP_CONFIG.getStringList("playerView.lore");
        boolean isEnchant = ConfigUtil.ADMIN_SHOP_CONFIG.getBoolean("playerView.isEnchant");
        int customModelData = ConfigUtil.ADMIN_SHOP_CONFIG.getInt("playerView.custom-model-data");
        boolean hideFlag = ConfigUtil.ADMIN_SHOP_CONFIG.getBoolean("playerView.hideFlag", true);
        int i2 = 0;
        for (TitlePlayer titlePlayer : page.getRecords()) {
            String displayName = StrUtil.replace(name, "player_name", titlePlayer.getPlayerName());
            ItemStack itemStack = ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, this.getReplaceMap(titlePlayer));
            HavePlayerGui.setHead(titlePlayer, itemStack);
            Integer index = indexList.get(i2++);
            inventory.setItem(index.intValue(), itemStack);
            intMap.put(index, titlePlayer.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "pane");
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "back");
    }

    private Map<String, String> getReplaceMap(TitlePlayer titlePlayer) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("player_name", titlePlayer.getPlayerName());
        map.put("expiration_time", DateUtil.format(titlePlayer.getExpirationTime(), "yyyy-MM-dd"));
        if (DateUtil.isPerpetual(titlePlayer.getExpirationTime())) {
            map.put("expiration_time", BaseUtil.getLangMsg("perpetual"));
        }
        return map;
    }

    public static void setHead(TitlePlayer titlePlayer, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta) || StrUtil.isEmpty(titlePlayer.getPlayerName())) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        skullMeta.setOwner(titlePlayer.getPlayerName());
        itemStack.setItemMeta((ItemMeta)skullMeta);
    }
}

