/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ViewShopGui {
    private static final ViewShopGui INSTANCE = new ViewShopGui();

    private ViewShopGui() {
    }

    public static ViewShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.VIEW_SHOP_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.VIEW_SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(BuyTypeEnum.ALL.getBuyType());
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        String searchType = handyInventory.getSearchType();
        String indexListStr = ConfigUtil.VIEW_SHOP_CONFIG.getString("shop.index");
        List<Integer> indexList = StrUtil.strToIntList(indexListStr);
        handyInventory.setPageSize(indexList.size());
        Page<TitleList> page = TitleListService.getInstance().findPage(null, handyInventory.getPageNum(), handyInventory.getPageSize(), null, BuyTypeEnum.ALL.getBuyType().equalsIgnoreCase(searchType) ? null : searchType);
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String material = ConfigUtil.VIEW_SHOP_CONFIG.getString("shop.material");
        boolean isEnchant = ConfigUtil.VIEW_SHOP_CONFIG.getBoolean("shop.isEnchant");
        int customModelDataId = ConfigUtil.VIEW_SHOP_CONFIG.getInt("shop.custom-model-data");
        int i2 = 0;
        for (TitleList titleList : page.getRecords()) {
            List<String> loreList = ConfigUtil.VIEW_SHOP_CONFIG.getStringList("shop.lore");
            HashMap<String, List<String>> replaceBatchMap = MapUtil.newHashMapWithExpectedSize(3);
            replaceBatchMap.put("description", TitleUtil.getDescription(titleList.getDescription()));
            replaceBatchMap.put("buff", TitleUtil.getBuff(titleList.getTitleBuffs()));
            replaceBatchMap.put("particle", TitleUtil.getParticle(titleList.getTitleParticle()));
            Map<String, String> replaceMap = this.getReplaceMap(titleList, handyInventory.getPlayer());
            loreList = ItemStackUtil.loreReplaceMap(loreList, replaceMap);
            loreList = ItemStackUtil.loreBatchReplaceMap(loreList, replaceBatchMap, BaseUtil.getLangMsg("not"));
            String titleMaterial = ConfigUtil.MATERIAL_CONFIG.getString(titleList.getId().toString(), material);
            int titleCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt(titleList.getId() + "_custom-model-data", customModelDataId);
            String titleName = PlaceholderApiUtil.set(handyInventory.getPlayer(), titleList.getTitleName());
            loreList = PlaceholderApiUtil.set(handyInventory.getPlayer(), loreList);
            ItemStack itemStack = ItemStackUtil.getItemStack(titleMaterial, titleName, loreList, isEnchant, titleCustomModelDataId);
            Integer index = indexList.get(i2++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, titleList.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_SHOP_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setCustomButton(ConfigUtil.VIEW_SHOP_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> getReplaceMap(TitleList titleList, Player player) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(7);
        map.put("buyType", BaseUtil.getLangMsg("buyType." + titleList.getBuyType()));
        String titleName = PlaceholderApiUtil.set(player, titleList.getTitleName());
        map.put("titleName", titleName);
        map.put("price", titleList.getAmount().toString());
        map.put("id", titleList.getId().toString());
        map.put("status", ConfigUtil.VIEW_SHOP_CONFIG.getString(titleList.getIsHide() != false ? "hide" : "show"));
        map.put("day", titleList.getDay() != 0 ? titleList.getDay() + BaseUtil.getLangMsg("shop.day") : BaseUtil.getLangMsg("perpetual"));
        int haveCount = TitlePlayerService.getInstance().findCount(titleList.getId());
        map.put("haveCount", String.valueOf(haveCount));
        BuyTypeEnum buyTypeEnum = BuyTypeEnum.getEnumThrow(titleList.getBuyType());
        switch (buyTypeEnum) {
            case VAULT: 
            case PLAYER_POINTS: 
            case COIN: {
                map.put("price", titleList.getAmount().toString());
                break;
            }
            case ITEM_STACK: {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleList.getItemStack());
                map.put("buyType", BaseUtil.getDisplayName(ItemStackUtil.getItemMeta(itemStack).getDisplayName(), itemStack.getType().toString()));
                map.put("price", titleList.getAmount().toString());
                break;
            }
        }
        return map;
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", BaseUtil.getLangMsg("buyType." + searchType));
        map.put("nextType", BaseUtil.getLangMsg("buyType." + BuyTypeEnum.getNextEnum(searchType)));
        return map;
    }
}

