/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener;

import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.annotation.HandyListener;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.HandyHttpUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.service.TitleRewardLogService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@HandyListener
public class PlayerJoinEventListener
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            TitlePlayerService.getInstance().updatePlayerName(player);
            TitleCoinService.getInstance().updatePlayerName(player);
            TitleRewardLogService.getInstance().updatePlayerName(player);
            this.removeTitle(player);
            TitleUtil.setPermissionTitle(player);
            TitleUtil.setPlayerTitle(player);
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onOpPlayerJoin(PlayerJoinEvent event) {
        if (!ConfigUtil.CONFIG.getBoolean("isCheckUpdateToOpMsg")) {
            return;
        }
        HandyHttpUtil.checkVersion(event.getPlayer(), "https://api.github.com/repos/handy-git/PlayerTitleVersions/releases/latest");
    }

    private void removeTitle(Player player) {
        List<TitleList> permissionTitles;
        List<TitlePlayer> expirationTitleList = TitlePlayerService.getInstance().findExpiration(player.getName());
        if (CollUtil.isNotEmpty(expirationTitleList)) {
            TitlePlayerService.getInstance().removeExpiration(player.getName());
            List nameList = expirationTitleList.stream().map(TitlePlayer::getTitleName).collect(Collectors.toList());
            String overdueMsg = ConfigUtil.LANG_CONFIG.getString("overdueMsg", "");
            MessageUtil.sendMessage(player, StrUtil.replace(overdueMsg, "title", CollUtil.listToStr(nameList)));
        }
        if (CollUtil.isEmpty(permissionTitles = TitlePlayerService.getInstance().findPermissionByPlayerName(player.getName()))) {
            return;
        }
        ArrayList<Integer> removeIds = new ArrayList<Integer>();
        ArrayList<String> titleNameList = new ArrayList<String>();
        for (TitleList permissionTitle : permissionTitles) {
            if (player.hasPermission(permissionTitle.getItemStack())) continue;
            removeIds.add(permissionTitle.getId());
            String titleName = BaseUtil.replaceChatColor(permissionTitle.getTitleName());
            titleNameList.add(PlaceholderApiUtil.set(player, titleName));
        }
        if (CollUtil.isEmpty(removeIds)) {
            return;
        }
        TitlePlayerService.getInstance().removePlayerTitleList(player.getName(), removeIds);
        String overdueMsg = ConfigUtil.LANG_CONFIG.getString("overdueMsg", "");
        MessageUtil.sendMessage(player, StrUtil.replace(overdueMsg, "title", CollUtil.listToStr(titleNameList)));
    }
}

