/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.api.param.TitleBuffParam;
import com.handy.playertitle.api.param.TitleListParam;
import com.handy.playertitle.api.param.TitleParticleParam;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.Db;
import com.handy.playertitle.lib.db.SqlUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TitleListService {
    private TitleListService() {
    }

    public static TitleListService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Integer add(TitleListParam titleListParam) {
        TitleList titleList = new TitleList();
        titleList.setTitleName(titleListParam.getTitleName());
        titleList.setBuyType(titleListParam.getBuyType());
        titleList.setAmount(titleListParam.getAmount());
        titleList.setDay(titleListParam.getDay());
        titleList.setItemStack(titleListParam.getItemStack());
        titleList.setIsHide(titleListParam.getIsHide() == 1);
        titleList.setDescription(titleListParam.getDescription());
        Integer titleId = this.add(titleList);
        if (CollUtil.isNotEmpty(titleListParam.getTitleBuffs())) {
            for (TitleBuffParam titleBuffParam : titleListParam.getTitleBuffs()) {
                if (titleBuffParam.getBuffType() == null || StrUtil.isEmpty(titleBuffParam.getBuffContent())) continue;
                TitleBuff titleBuff = new TitleBuff();
                titleBuff.setTitleId(titleId);
                titleBuff.setBuffType(titleBuffParam.getBuffType().getBuffType());
                titleBuff.setBuffContent(titleBuffParam.getBuffContent());
                titleBuff.setDescription(titleBuffParam.getDescription());
                TitleBuffService.getInstance().add(titleBuff);
            }
        }
        if (titleListParam.getTitleParticle() != null) {
            TitleParticleService.getInstance().add(this.getTitleParticle(titleListParam, titleId));
        }
        return titleId;
    }

    private TitleParticle getTitleParticle(TitleListParam titleListParam, Integer titleId) {
        TitleParticleParam titleParticleParam = titleListParam.getTitleParticle();
        TitleParticle titleParticle = new TitleParticle();
        titleParticle.setTitleId(titleId);
        titleParticle.setParticleType(titleParticleParam.getParticleType().getParticleType());
        titleParticle.setSuperTrailsId(titleParticleParam.getSuperTrailsId());
        titleParticle.setWingColor(titleParticleParam.getWingColor());
        titleParticle.setWingContour(titleParticleParam.getWingContour());
        titleParticle.setWingThirdColor(titleParticleParam.getWingThirdColor());
        return titleParticle;
    }

    public Integer add(TitleList titleList) {
        return Db.use(TitleList.class).execution().insert(titleList);
    }

    public boolean removeById(Integer id) {
        boolean rst;
        boolean bl = rst = Db.use(TitleList.class).execution().deleteById(id) > 0;
        if (rst) {
            TitlePlayerService.getInstance().removeByTitleId(id);
            TitleBuffService.getInstance().removeByTitleId(id);
            TitleParticleService.getInstance().removeByTitleId(id);
            for (Player player : Bukkit.getOnlinePlayers()) {
                TitleUtil.setPlayerTitle(player);
            }
        }
        return rst;
    }

    public Optional<TitleList> findById(Integer id) {
        return Db.use(TitleList.class).execution().selectById(id);
    }

    public Optional<TitleList> findTitleById(Integer id) {
        Optional<TitleList> titleListOptional = Db.use(TitleList.class).execution().selectById(id);
        if (titleListOptional.isPresent()) {
            TitleList titleList = titleListOptional.get();
            titleList.setTitleBuffs(TitleBuffService.getInstance().findByTitleId(id));
            titleList.setTitleParticle(TitleParticleService.getInstance().findByTitleId(id).orElse(null));
        }
        return titleListOptional;
    }

    public List<Integer> findByBuyType(String buyType) {
        List<TitleList> list = this.findAllByBuyType(buyType);
        return list.stream().map(TitleList::getId).collect(Collectors.toList());
    }

    public List<TitleList> findAllByBuyType(String buyType) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.where().eq(StrUtil.isNotEmpty(buyType), TitleList::getBuyType, buyType);
        return use.execution().list();
    }

    public Page<TitleList> findPage(List<Integer> idList, Integer pageNum, Integer pageSize, Boolean isHide, String buyType) {
        Db<TitleList> use = Db.use(TitleList.class);
        Integer oneHundredCount = this.findOneHundredCount();
        use.where().eq(StrUtil.isNotEmpty(buyType), TitleList::getBuyType, buyType).eq(isHide != null, TitleList::getIsHide, isHide).notIn(CollUtil.isNotEmpty(idList), TitleList::getId, idList).lt(!SqlUtil.isGenuine() && oneHundredCount > 0, TitleList::getId, oneHundredCount).limit(pageNum, pageSize);
        Page<TitleList> page = use.execution().page();
        this.setExtraData(page.getRecords());
        return page;
    }

    private void setExtraData(List<TitleList> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<Integer> titleIds = list.stream().map(TitleList::getId).collect(Collectors.toList());
        List<TitleBuff> buffList = TitleBuffService.getInstance().findByTitleIdList(titleIds);
        for (TitleList titleList : list) {
            titleList.setTitleBuffs(new ArrayList<TitleBuff>());
            for (TitleBuff titleBuff : buffList) {
                if (!titleList.getId().equals(titleBuff.getTitleId())) continue;
                titleList.getTitleBuffs().add(titleBuff);
            }
        }
        List<TitleParticle> titleParticles = TitleParticleService.getInstance().findByTitleIdList(titleIds);
        for (TitleList titleList : list) {
            for (TitleParticle titleParticle : titleParticles) {
                if (!titleList.getId().equals(titleParticle.getTitleId())) continue;
                titleList.setTitleParticle(titleParticle);
            }
        }
    }

    public List<TitleList> findAll() {
        return Db.use(TitleList.class).execution().list();
    }

    public Boolean updateAmount(Integer id, Integer amount) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getAmount, amount);
        return use.execution().updateById(id) > 0;
    }

    public Boolean updateDay(Integer id, Integer day) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getDay, day);
        return use.execution().updateById(id) > 0;
    }

    public void updateIsHide(Integer id, boolean isHide) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getIsHide, isHide);
        use.execution().updateById(id);
    }

    public Boolean updateBuyType(Integer id, String buyType) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getBuyType, buyType);
        return use.execution().updateById(id) > 0;
    }

    public boolean updateName(Integer id, String titleName) {
        boolean rst;
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getTitleName, titleName);
        boolean bl = rst = use.execution().updateById(id) > 0;
        if (rst) {
            TitlePlayerService.getInstance().updateTitleName(id, titleName);
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                TitleUtil.setCache(onlinePlayer);
            }
        }
        return rst;
    }

    public Boolean updateItemStack(Integer id, String itemStack) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getItemStack, itemStack);
        return use.execution().updateById(id) > 0;
    }

    public boolean updateDescription(Integer id, String description) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.update().set(TitleList::getDescription, description);
        return use.execution().updateById(id) > 0;
    }

    public int findCount() {
        return Db.use(TitleList.class).execution().count();
    }

    public Integer findOneHundredCount() {
        Db<TitleList> use = Db.use(TitleList.class);
        use.where().limit(100, 1);
        Optional<TitleList> titleListOptional = use.execution().selectOne();
        return titleListOptional.isPresent() ? titleListOptional.get().getId() : 0;
    }

    public List<TitleList> findByIds(List<Integer> titleIds) {
        return Db.use(TitleList.class).execution().selectBatchIds(titleIds);
    }

    public List<TitleList> findByIdsAndBuyType(List<Integer> titleIds, String buyType) {
        Db<TitleList> use = Db.use(TitleList.class);
        use.where().in(TitleList::getId, titleIds).eq(TitleList::getBuyType, buyType);
        return use.execution().list();
    }

    public void removeAll() {
        Db.use(TitleList.class).execution().delete();
    }

    private static class SingletonHolder {
        private static final TitleListService INSTANCE = new TitleListService();

        private SingletonHolder() {
        }
    }
}

