/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.hook;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.entity.TitleCoin;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.BaseUtil;
import com.handy.playertitle.lib.CollUtil;
import com.handy.playertitle.lib.NumberUtil;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.List;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class PlaceholderUtil
extends PlaceholderExpansion {
    private final PlayerTitle plugin;

    public PlaceholderUtil(PlayerTitle plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "playerTitle";
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        if (player == null) {
            return null;
        }
        if ("number".equals(identifier)) {
            int count = TitlePlayerService.getInstance().findCount(player.getUniqueId());
            return String.valueOf(count);
        }
        if ("coin".equals(identifier)) {
            Optional<TitleCoin> titleCoinOptional = TitleCoinService.getInstance().findByPlayerUuid(player.getUniqueId());
            return titleCoinOptional.isPresent() ? String.valueOf(titleCoinOptional.get().getAmount()) : "0";
        }
        if (identifier.contains("count")) {
            String titleId = identifier.replace("count_", "");
            int count = TitlePlayerService.getInstance().findCount(NumberUtil.isNumericToInt(titleId, 0));
            return String.valueOf(count);
        }
        if (identifier.contains("have")) {
            String titleId = identifier.replace("have_", "");
            Optional<TitlePlayer> titlePlayerOptional = TitlePlayerService.getInstance().findByPlayerAndTitleId(player.getUniqueId(), NumberUtil.isNumericToInt(titleId, 0));
            return titlePlayerOptional.isPresent() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        String[] split = identifier.split("_");
        TitleUseTypeEnum useType = TitleUseTypeEnum.SHOW;
        if (split.length > 1) {
            useType = TitleUseTypeEnum.getByUseType(split[1]);
        }
        TitlePlayer titlePlayer = null;
        switch (useType) {
            case SHOW: {
                titlePlayer = TitleConstants.TITLE_PLAYER_SHOW_MAP.get(player.getUniqueId());
                break;
            }
            case BUFF: {
                titlePlayer = TitleConstants.TITLE_PLAYER_BUFF_MAP.get(player.getUniqueId());
                break;
            }
            case PARTICLE: {
                titlePlayer = TitleConstants.TITLE_PLAYER_PARTICLE_MAP.get(player.getUniqueId());
                break;
            }
        }
        if (titlePlayer == null) {
            titlePlayer = TitlePlayerService.getInstance().findByPlayerAndUseType(player.getUniqueId(), useType).orElse(null);
        }
        switch (identifier) {
            case "use": 
            case "use_buff": 
            case "use_particle": {
                String defaultTitle = ConfigUtil.CONFIG.getString("default");
                if (titlePlayer != null) {
                    defaultTitle = titlePlayer.getTitleName();
                }
                defaultTitle = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)defaultTitle);
                return BaseUtil.replaceChatColor(defaultTitle);
            }
            case "strip_color_use": 
            case "strip_color_use_buff": 
            case "strip_color_use_particle": {
                String stripColorDefaultTitle = ConfigUtil.CONFIG.getString("default");
                if (titlePlayer != null) {
                    stripColorDefaultTitle = titlePlayer.getTitleName();
                }
                stripColorDefaultTitle = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)stripColorDefaultTitle);
                return BaseUtil.stripColor(stripColorDefaultTitle);
            }
            case "raw_text_use": 
            case "raw_text_use_buff": 
            case "raw_text_use_particle": {
                String rawTextDefaultTitle = ConfigUtil.CONFIG.getString("default");
                if (titlePlayer != null) {
                    rawTextDefaultTitle = titlePlayer.getTitleName();
                }
                return rawTextDefaultTitle;
            }
            case "description": 
            case "description_buff": 
            case "description_particle": {
                String description = BaseUtil.getLangMsg("shop.noBuff");
                if (titlePlayer != null) {
                    description = titlePlayer.getDescription();
                }
                return BaseUtil.replaceChatColor(description);
            }
            case "buff": 
            case "buff_buff": 
            case "buff_particle": {
                String buff = BaseUtil.getLangMsg("shop.noBuff");
                if (titlePlayer != null && CollUtil.isNotEmpty(titlePlayer.getTitleBuffs())) {
                    List<String> buffs = TitleUtil.getBuff(titlePlayer.getTitleBuffs());
                    buff = CollUtil.listToStr(buffs);
                }
                return BaseUtil.replaceChatColor(buff);
            }
            case "particle": 
            case "particle_buff": 
            case "particle_particle": {
                String particle = BaseUtil.getLangMsg("shop.noBuff");
                if (titlePlayer != null && titlePlayer.getTitleParticle() != null) {
                    List<String> particleList = TitleUtil.getParticle(titlePlayer.getTitleParticle());
                    particle = CollUtil.listToStr(particleList);
                }
                return BaseUtil.replaceChatColor(particle);
            }
            case "use_id": 
            case "use_buff_id": 
            case "use_particle_id": {
                if (titlePlayer != null) {
                    return titlePlayer.getTitleId().toString();
                }
                return null;
            }
        }
        return null;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

