/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.command;

import cn.handyplus.warp.lib.command.HandySubCommandParam;
import cn.handyplus.warp.lib.command.IHandyCommandEvent;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.exception.HandyException;
import cn.handyplus.warp.lib.util.GenuineUtil;
import cn.handyplus.warp.lib.util.MessageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class HandyCommandFactory {
    private static final HandyCommandFactory INSTANCE = new HandyCommandFactory();
    private static final Map<String, IHandyCommandEvent> HANDY_COMMAND_EVENT_MAP = new HashMap<String, IHandyCommandEvent>();
    private static Map<String, Map<String, HandySubCommandParam>> SUB_COMMAND_MAP = new HashMap<String, Map<String, HandySubCommandParam>>();

    private HandyCommandFactory() {
    }

    public static HandyCommandFactory getInstance() {
        return INSTANCE;
    }

    public void init(List<IHandyCommandEvent> handyCommandEvents) {
        if (CollUtil.isEmpty(handyCommandEvents)) {
            return;
        }
        for (IHandyCommandEvent handyCommandEvent : handyCommandEvents) {
            HANDY_COMMAND_EVENT_MAP.put(handyCommandEvent.command().toLowerCase(), handyCommandEvent);
        }
    }

    public void initSubCommand(Map<String, Map<String, HandySubCommandParam>> subCommandMap) {
        SUB_COMMAND_MAP = subCommandMap;
    }

    public boolean onSubCommand(String command, CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        if (args.length == 0) {
            return false;
        }
        Map<String, HandySubCommandParam> subCommandParamMap = SUB_COMMAND_MAP.get(command.toLowerCase());
        if (subCommandParamMap == null) {
            return false;
        }
        HandySubCommandParam param = subCommandParamMap.get(args[0].toLowerCase());
        if (param == null) {
            return false;
        }
        if (StrUtil.isNotEmpty(param.getPermission()) && !sender.hasPermission(param.getPermission())) {
            MessageUtil.sendMessage(sender, StrUtil.replace(noPermission, "permission", param.getPermission()));
            return true;
        }
        if (GenuineUtil.isCommandPermission(args[0])) {
            MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u672a\u68c0\u6d4b\u5230\u6fc0\u6d3b\u7801,\u8bf7\u8054\u7cfb\u4f5c\u8005\u8d2d\u4e70QQ:956812056");
            return true;
        }
        try {
            param.getMethod().invoke(param.getAClass().newInstance(), sender, cmd, label, args);
        }
        catch (HandyException exception) {
            MessageUtil.sendMessage(sender, exception.getMessage());
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        if (args.length == 0) {
            return false;
        }
        IHandyCommandEvent handyInventory = HANDY_COMMAND_EVENT_MAP.get(args[0].toLowerCase());
        if (handyInventory == null) {
            return false;
        }
        if (StrUtil.isNotEmpty(handyInventory.permission()) && !sender.hasPermission(handyInventory.permission())) {
            MessageUtil.sendMessage(sender, StrUtil.replace(noPermission, "permission", handyInventory.permission()));
            return true;
        }
        if (GenuineUtil.isCommandPermission(args[0])) {
            MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u672a\u68c0\u6d4b\u5230\u6fc0\u6d3b\u7801,\u8bf7\u8054\u7cfb\u4f5c\u8005\u8d2d\u4e70QQ:956812056");
            return true;
        }
        try {
            handyInventory.onCommand(sender, cmd, label, args);
        }
        catch (HandyException exception) {
            MessageUtil.sendMessage(sender, exception.getMessage());
        }
        return true;
    }
}

