/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.util;

import cn.handyplus.warp.lib.constants.BaseConstants;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.exception.HandyException;
import cn.handyplus.warp.lib.util.BaseUtil;
import java.util.Collection;
import java.util.regex.Matcher;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AssertUtil {
    private AssertUtil() {
    }

    public static void isTrue(boolean expression, CommandSender sender, String message) {
        AssertUtil.notTrue(!expression, sender, message);
    }

    public static void notTrue(boolean expression, CommandSender sender, String message) {
        if (expression) {
            throw new HandyException(message);
        }
    }

    public static void notNull(Object object, CommandSender sender, String message) {
        if (object == null) {
            throw new HandyException(message);
        }
    }

    public static void notEmpty(String str, CommandSender sender, String message) {
        if (StrUtil.isEmpty(str)) {
            throw new HandyException(message);
        }
    }

    public static <T> void notNull(Collection<T> collection, CommandSender sender, String message) {
        if (CollUtil.isEmpty(collection)) {
            throw new HandyException(message);
        }
    }

    public static Player notPlayer(CommandSender sender, String message) {
        if (BaseUtil.isNotPlayer(sender).booleanValue()) {
            throw new HandyException(message);
        }
        return (Player)sender;
    }

    public static Integer isNumericToInt(String str, CommandSender sender, String message) {
        try {
            Matcher isNum = BaseConstants.NUMERIC.matcher(str);
            if (isNum.matches()) {
                return Integer.valueOf(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new HandyException(message);
    }

    public static Long isNumericToLong(String str, CommandSender sender, String message) {
        try {
            Matcher isNum = BaseConstants.NUMERIC.matcher(str);
            if (isNum.matches()) {
                return Long.parseLong(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new HandyException(message);
    }
}

