/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.google.common.base.Preconditions;
import com.plotsquared.bukkit.util.BukkitBlockUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.annotations.informative.DoNotUse;
import com.plotsquared.core.location.ChunkWrapper;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkUtil;
import com.plotsquared.core.util.PatternUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DoNotUse
public class GenChunk
extends ZeroedDelegateScopedQueueCoordinator {
    public final Biome[] biomes = Biome.values();
    public BlockState[][] result;
    public ChunkGenerator.BiomeGrid biomeGrid;
    public Chunk chunk;
    public String world;
    public int chunkX;
    public int chunkZ;
    private ChunkGenerator.ChunkData chunkData = null;

    public GenChunk(int minY, int maxY) {
        super(null, Location.at("", 0, minY, 0), Location.at("", 15, maxY, 15));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ChunkGenerator.ChunkData getChunkData() {
        return this.chunkData;
    }

    public void setChunkData(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ChunkGenerator.ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    public @NonNull Chunk getChunk() {
        org.bukkit.World worldObj;
        if (this.chunk == null && (worldObj = BukkitUtil.getWorld(this.world)) != null) {
            this.chunk = worldObj.getChunkAt(this.chunkX, this.chunkZ);
        }
        return this.chunk;
    }

    public void setChunk(@NonNull Chunk chunk) {
        this.chunk = chunk;
    }

    public void setChunk(@NonNull ChunkWrapper wrap) {
        this.chunk = null;
        this.world = wrap.world();
        this.chunkX = wrap.x();
        this.chunkZ = wrap.z();
    }

    @Override
    public void fillBiome(@NonNull BiomeType biomeType) {
        if (this.biomeGrid == null) {
            return;
        }
        Biome biome = BukkitAdapter.adapt((BiomeType)biomeType);
        for (int y = this.getMin().getY(); y <= this.getMax().getY(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.biomeGrid.setBiome(x, y, z, biome);
                }
            }
        }
    }

    @Override
    public void setCuboid(@NonNull Location pos1, @NonNull Location pos2, @NonNull BlockState block) {
        if (this.result != null && pos1.getX() == 0 && pos1.getZ() == 0 && pos2.getX() == 15 && pos2.getZ() == 15) {
            for (int y = pos1.getY(); y <= pos2.getY(); ++y) {
                int layer = this.getLayerIndex(y);
                Object[] data = this.result[layer];
                if (data == null) {
                    data = new BlockState[4096];
                    this.result[layer] = data;
                }
                int start = y << 8;
                int end = start + 256;
                Arrays.fill(data, start, end, block);
            }
        }
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        this.chunkData.setRegion(minX, minY, minZ, maxX + 1, maxY + 1, maxZ + 1, BukkitAdapter.adapt((BlockStateHolder)block));
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biomeType) {
        return this.setBiome(x, z, BukkitAdapter.adapt((BiomeType)biomeType));
    }

    public boolean setBiome(int x, int z, @NonNull Biome biome) {
        if (this.biomeGrid != null) {
            for (int y = this.getMin().getY(); y <= this.getMax().getY(); ++y) {
                this.setBiome(x, y, z, biome);
            }
            return true;
        }
        return false;
    }

    public boolean setBiome(int x, int y, int z, @NonNull Biome biome) {
        if (this.biomeGrid != null) {
            this.biomeGrid.setBiome(x, y, z, biome);
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        BaseBlock block = PatternUtil.apply((Pattern)Preconditions.checkNotNull((Object)pattern, (Object)"Pattern may not be null"), x + (this.chunkX << 4), y, z + (this.chunkZ << 4));
        return this.setBlock(x, y, z, block);
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        if (this.result == null) {
            this.chunkData.setBlock(x, y, z, BukkitAdapter.adapt((BlockStateHolder)id));
            return true;
        }
        this.chunkData.setBlock(x, y, z, BukkitAdapter.adapt((BlockStateHolder)id));
        this.storeCache(x, y, z, id);
        return true;
    }

    private void storeCache(int x, int y, int z, @NonNull BlockState id) {
        int i = this.getLayerIndex(y);
        BlockState[] v = this.result[i];
        if (v == null) {
            v = new BlockState[4096];
            this.result[i] = v;
        }
        int j = ChunkUtil.getJ(x, y, z);
        v[j] = id;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        if (this.result == null) {
            this.chunkData.setBlock(x, y, z, BukkitAdapter.adapt((BlockStateHolder)id));
            return true;
        }
        this.chunkData.setBlock(x, y, z, BukkitAdapter.adapt((BlockStateHolder)id));
        this.storeCache(x, y, z, id.toImmutableState());
        return true;
    }

    @Override
    public @Nullable BlockState getBlock(int x, int y, int z) {
        int i = this.getLayerIndex(y);
        if (this.result == null) {
            return BukkitBlockUtil.get(this.chunkData.getType(x, y, z));
        }
        BlockState[] array = this.result[i];
        if (array == null) {
            return BlockTypes.AIR.getDefaultState();
        }
        int j = ChunkUtil.getJ(x, y, z);
        return array[j];
    }

    public int getX() {
        return this.chunk == null ? this.chunkX : this.chunk.getX();
    }

    public int getZ() {
        return this.chunk == null ? this.chunkZ : this.chunk.getZ();
    }

    @Override
    public @NonNull World getWorld() {
        return this.chunk == null ? BukkitAdapter.adapt((org.bukkit.World)Bukkit.getWorld((String)this.world)) : BukkitAdapter.adapt((org.bukkit.World)this.chunk.getWorld());
    }

    @Override
    public @NonNull Location getMax() {
        return Location.at(this.getWorld().getName(), 15 + (this.getX() << 4), super.getMax().getY(), 15 + (this.getZ() << 4));
    }

    @Override
    public @NonNull Location getMin() {
        return Location.at(this.getWorld().getName(), this.getX() << 4, super.getMin().getY(), this.getZ() << 4);
    }

    public @NonNull GenChunk clone() {
        GenChunk toReturn = new GenChunk(this.getMin().getY(), this.getMax().getY());
        if (this.result != null) {
            for (int i = 0; i < this.result.length; ++i) {
                BlockState[] matrix = this.result[i];
                if (matrix == null) continue;
                toReturn.result[i] = new BlockState[matrix.length];
                System.arraycopy(matrix, 0, toReturn.result[i], 0, matrix.length);
            }
        }
        toReturn.chunkData = this.chunkData;
        return toReturn;
    }

    private int getLayerIndex(int y) {
        return y - this.getMin().getY() >> 4;
    }
}

