/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.plotsquared.bukkit.schematic.StateWrapper;
import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.LimitedRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LimitedRegionWrapperQueue
extends DelegateQueueCoordinator {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + LimitedRegionWrapperQueue.class.getSimpleName()));
    private final LimitedRegion limitedRegion;
    private boolean useOtherRestoreTagMethod = false;

    public LimitedRegionWrapperQueue(LimitedRegion limitedRegion) {
        super((QueueCoordinator)null);
        this.limitedRegion = limitedRegion;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        return this.setBlock(x, y, z, pattern.applyBlock(BlockVector3.at((int)x, (int)y, (int)z)));
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        boolean result = this.setBlock(x, y, z, id.toImmutableState());
        if (result && id.hasNbtData()) {
            CompoundTag tag = id.getNbtData();
            StateWrapper sw = new StateWrapper(tag);
            try {
                if (this.useOtherRestoreTagMethod && this.getWorld() != null) {
                    sw.restoreTag(this.getWorld().getName(), x, y, z);
                } else {
                    sw.restoreTag(this.limitedRegion.getBlockState(x, y, z).getBlock());
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Error attempting to populate tile entity into the world at location {},{},{}", (Object)x, (Object)y, (Object)z, (Object)e);
                return false;
            }
            catch (IllegalStateException e) {
                this.useOtherRestoreTagMethod = true;
                LOGGER.warn("IllegalStateException attempting to populate tile entity into the world at location {},{},{}. Possibly on <=1.17.1, switching to secondary method.", (Object)x, (Object)y, (Object)z, (Object)e);
            }
        }
        return result;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        try {
            this.limitedRegion.setType(x, y, z, BukkitAdapter.adapt((BlockType)id.getBlockType()));
            this.limitedRegion.setBlockData(x, y, z, BukkitAdapter.adapt((BlockStateHolder)id));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error attempting to populate block into the world at location {},{},{}", (Object)x, (Object)y, (Object)z, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean setEntity(@NonNull Entity entity) {
        EntityType type = BukkitAdapter.adapt((com.sk89q.worldedit.world.entity.EntityType)entity.getState().getType());
        double x = entity.getLocation().getX();
        double y = entity.getLocation().getY();
        double z = entity.getLocation().getZ();
        Location location = new Location(this.limitedRegion.getWorld(), x, y, z);
        try {
            this.limitedRegion.spawnEntity(location, type);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error attempting to populate entity into the world at location {},{},{}", (Object)((int)x), (Object)((int)y), (Object)((int)z), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        StateWrapper sw = new StateWrapper(tag);
        try {
            return sw.restoreTag(this.limitedRegion.getBlockState(x, y, z).getBlock());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error attempting to populate tile entity into the world at location {},{},{}", (Object)x, (Object)y, (Object)z, (Object)e);
            return false;
        }
    }

    @Override
    public boolean isSettingTiles() {
        return true;
    }
}

