/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LuckPermsUUIDService
implements UUIDService {
    private final LuckPerms luckPerms;

    public LuckPermsUUIDService() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            throw new IllegalStateException("LuckPerms not available");
        }
        this.luckPerms = (LuckPerms)provider.getProvider();
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> uuids) {
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(uuids.size());
        UserManager userManager = this.luckPerms.getUserManager();
        for (UUID uuid : uuids) {
            try {
                String username = (String)userManager.lookupUsername(uuid).get();
                if (username == null) continue;
                mappings.add(new UUIDMapping(uuid, username));
            }
            catch (Exception exception) {}
        }
        return mappings;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> usernames) {
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(usernames.size());
        UserManager userManager = this.luckPerms.getUserManager();
        for (String username : usernames) {
            try {
                UUID uuid = (UUID)userManager.lookupUniqueId(username).get();
                if (username == null) continue;
                mappings.add(new UUIDMapping(uuid, username));
            }
            catch (Exception exception) {}
        }
        return mappings;
    }
}

