/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.google.common.util.concurrent.RateLimiter;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import com.plotsquared.squirrelid.squirrelid.Profile;
import com.plotsquared.squirrelid.squirrelid.resolver.HttpRepositoryService;
import com.plotsquared.squirrelid.squirrelid.resolver.ProfileService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SquirrelIdUUIDService
implements UUIDService {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SquirrelIdUUIDService.class.getSimpleName()));
    private final ProfileService profileService = HttpRepositoryService.forMinecraft();
    private final RateLimiter rateLimiter;

    public SquirrelIdUUIDService(int rateLimit) {
        this.rateLimiter = RateLimiter.create((double)((double)rateLimit / 600.0));
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> uuids) {
        ArrayList<UUIDMapping> results = new ArrayList<UUIDMapping>(uuids.size());
        this.rateLimiter.acquire(uuids.size());
        try {
            try {
                for (Profile profile : this.profileService.findAllByUuid(uuids)) {
                    results.add(new UUIDMapping(profile.getUniqueId(), profile.getName()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (uuids.size() >= 2) {
                    if (Settings.DEBUG) {
                        LOGGER.info("(UUID) Found invalid UUID in batch. Will try each UUID individually.");
                    }
                    for (UUID uuid : uuids) {
                        List<UUIDMapping> result = this.getNames(Collections.singletonList(uuid));
                        if (result.isEmpty()) continue;
                        results.add(result.get(0));
                    }
                } else if (uuids.size() == 1 && Settings.DEBUG) {
                    LOGGER.info("(UUID) Found invalid UUID: {}", (Object)uuids.get(0));
                }
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return results;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> usernames) {
        ArrayList<UUIDMapping> results = new ArrayList<UUIDMapping>(usernames.size());
        this.rateLimiter.acquire(usernames.size());
        try {
            for (Profile profile : this.profileService.findAllByName(usernames)) {
                results.add(new UUIDMapping(profile.getUniqueId(), profile.getName()));
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return results;
    }
}

