/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.arkitektonika.v1;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.arkitektonika.ApiVersion;
import com.plotsquared.core.arkitektonika.ResourceStatus;
import com.plotsquared.core.arkitektonika.Schematic;
import com.plotsquared.core.arkitektonika.SchematicKeys;
import com.plotsquared.core.arkitektonika.exceptions.InvalidFormatException;
import com.plotsquared.core.arkitektonika.exceptions.ResourceRetrievalException;
import com.plotsquared.core.arkitektonika.exceptions.ResourceUploadException;
import com.plotsquared.core.http.ContentType;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.HttpClient;
import com.plotsquared.core.http.HttpResponse;
import com.plotsquared.core.http.external.GsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public final class ApiClient
implements com.plotsquared.core.arkitektonika.ApiClient {
    private final HttpClient httpClient;

    public ApiClient(@NotNull String url) {
        this.httpClient = HttpClient.newBuilder().withBaseURL(url).withEntityMapper(EntityMapper.newInstance().registerDeserializer(JsonObject.class, GsonMapper.deserializer(JsonObject.class, new GsonBuilder().create())).registerSerializer(File.class, new SchematicSerializer())).build();
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return ApiVersion.V1_0_0;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> checkCompatibility(@NotNull ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = this.httpClient.get("/").onStatus(200, ignore -> {}).onRemaining(r -> {
                throw new ResourceRetrievalException("/", r.getStatusCode(), r.getStatus());
            }).execute();
            JsonObject object = Objects.requireNonNull(response, "Failed to retrieve response").getResponseEntity(JsonObject.class);
            return object.has("version") && object.get("version").getAsString().startsWith("1.");
        }, service);
    }

    @Override
    @NotNull
    public CompletableFuture<SchematicKeys> upload(@NotNull File file, @NotNull ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = this.httpClient.post("/upload").withInput(() -> file).onStatus(400, httpResponse -> {
                throw new InvalidFormatException("/upload", 400, httpResponse.getStatus());
            }).onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceUploadException("/upload", httpResponse.getStatusCode(), httpResponse.getStatus(), "Other");
            }).execute();
            JsonObject object = Objects.requireNonNull(response, "Failed to get response").getResponseEntity(JsonObject.class);
            return new SchematicKeys(object.get("download_key").getAsString(), object.get("delete_key").getAsString());
        }, service);
    }

    @Override
    @NotNull
    public CompletableFuture<ResourceStatus> checkStatus(@NotNull String key, @NotNull ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = this.httpClient.head(String.format("/download/%s", key)).execute();
            if (response == null) {
                throw new ResourceRetrievalException(String.format("/download/%s", key), 0, "Could not fetch response");
            }
            if (response.getStatusCode() == 200) {
                return ResourceStatus.OK;
            }
            if (response.getStatusCode() == 404) {
                return ResourceStatus.NON_EXISTENT;
            }
            if (response.getStatusCode() == 410) {
                return ResourceStatus.DELETED;
            }
            throw new ResourceRetrievalException(String.format("/download/%s", key), response.getStatusCode(), response.getStatus());
        }, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> delete(@NotNull String key, @NotNull ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = this.httpClient.delete(String.format("/delete/%s", key)).onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceRetrievalException(String.format("/delete/%s", key), httpResponse.getStatusCode(), httpResponse.getStatus());
            }).execute();
            if (response == null) {
                throw new ResourceRetrievalException(String.format("/delete/%s", key), 0, "Could not fetch response");
            }
            return true;
        }, service);
    }

    @Override
    @NotNull
    public CompletableFuture<Schematic> download(@NotNull String key, @NotNull ExecutorService service) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = this.httpClient.get(String.format("/download/%s", key)).onStatus(200, httpResponse -> {}).onRemaining(httpResponse -> {
                throw new ResourceRetrievalException(String.format("/download/%s", key), httpResponse.getStatusCode(), httpResponse.getStatus());
            }).execute();
            if (response == null) {
                throw new ResourceRetrievalException(String.format("/download/%s", key), 0, "Could not fetch response");
            }
            return new Schematic(key, response.getRawResponse());
        }, service);
    }

    private static final class SchematicSerializer
    implements EntityMapper.EntitySerializer<File> {
        private final String boundary = UUID.randomUUID().toString();

        private SchematicSerializer() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public byte[] serialize(@NotNull File file) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8), true);
                try {
                    printWriter.append("--").append(this.boundary).append("\r\n");
                    printWriter.append("Content-Disposition: form-data; name=\"schematic\"; filename=\"plot.schem\"\r\n");
                    printWriter.append("Content-Type: application/octet-stream\r\n\r\n").flush();
                    Files.copy(file.toPath(), byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                    printWriter.append("\r\n").flush();
                    printWriter.append("--").append(this.boundary).append("--\r\n").flush();
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    printWriter.close();
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return new byte[0];
            }
        }

        @Override
        public ContentType getContentType() {
            return ContentType.of(String.format("multipart/form-data; boundary=%s", this.boundary));
        }
    }
}

