/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.backup;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.backup.NullBackupProfile;
import com.plotsquared.core.backup.PlayerBackupProfile;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.inject.factory.PlayerBackupProfileFactory;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class SimpleBackupManager
implements BackupManager {
    private final Path backupPath;
    private final boolean automaticBackup;
    private final int backupLimit;
    private final Cache<PlotCacheKey, BackupProfile> backupProfileCache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();
    private final PlayerBackupProfileFactory playerBackupProfileFactory;

    @Inject
    public SimpleBackupManager(@NonNull PlayerBackupProfileFactory playerBackupProfileFactory) throws Exception {
        this.playerBackupProfileFactory = playerBackupProfileFactory;
        this.backupPath = Objects.requireNonNull(PlotSquared.platform()).getDirectory().toPath().resolve("backups");
        if (!Files.exists(this.backupPath, new LinkOption[0])) {
            Files.createDirectory(this.backupPath, new FileAttribute[0]);
        }
        this.automaticBackup = Settings.Backup.AUTOMATIC_BACKUPS;
        this.backupLimit = Settings.Backup.BACKUP_LIMIT;
    }

    public SimpleBackupManager(Path backupPath, boolean automaticBackup, int backupLimit, PlayerBackupProfileFactory playerBackupProfileFactory) {
        this.backupPath = backupPath;
        this.automaticBackup = automaticBackup;
        this.backupLimit = backupLimit;
        this.playerBackupProfileFactory = playerBackupProfileFactory;
    }

    @Override
    public @NonNull BackupProfile getProfile(@NonNull Plot plot) {
        if (plot.hasOwner()) {
            try {
                return (BackupProfile)this.backupProfileCache.get((Object)new PlotCacheKey(plot), () -> this.playerBackupProfileFactory.create(plot.getOwnerAbs(), plot));
            }
            catch (ExecutionException e) {
                PlayerBackupProfile profile = this.playerBackupProfileFactory.create(plot.getOwnerAbs(), plot);
                this.backupProfileCache.put((Object)new PlotCacheKey(plot), (Object)profile);
                return profile;
            }
        }
        return new NullBackupProfile();
    }

    @Override
    public void automaticBackup(@Nullable PlotPlayer<?> player, @NonNull Plot plot, @NonNull Runnable whenDone) {
        BackupProfile profile;
        if (!this.shouldAutomaticallyBackup() || (profile = this.getProfile(plot)) instanceof NullBackupProfile) {
            whenDone.run();
        } else {
            if (player != null) {
                player.sendMessage(TranslatableCaption.of("backups.backup_automatic_started"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            }
            profile.createBackup().whenComplete((backup, throwable) -> {
                if (throwable != null) {
                    if (player != null) {
                        player.sendMessage(TranslatableCaption.of("backups.backup_automatic_failure"), TagResolver.resolver("reason", Tag.inserting(Component.text(throwable.getMessage()))));
                    }
                    throwable.printStackTrace();
                } else if (player != null) {
                    player.sendMessage(TranslatableCaption.of("backups.backup_automatic_finished"), new TagResolver[0]);
                    TaskManager.runTaskAsync(whenDone);
                }
            });
        }
    }

    @Override
    public boolean shouldAutomaticallyBackup() {
        return this.automaticBackup;
    }

    @Override
    public Path getBackupPath() {
        return this.backupPath;
    }

    @Override
    public int getBackupLimit() {
        return this.backupLimit;
    }

    private record PlotCacheKey(Plot plot) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlotCacheKey that = (PlotCacheKey)o;
            return Objects.equals(this.plot.getArea(), that.plot.getArea()) && Objects.equals(this.plot.getId(), that.plot.getId()) && Objects.equals(this.plot.getOwnerAbs(), that.plot.getOwnerAbs());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.plot.getArea(), this.plot.getId(), this.plot.getOwnerAbs());
        }
    }
}

