/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="continue", permission="plots.continue", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER)
public class Continue
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Continue(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Plot plot = player.getCurrentPlot();
        if (plot == null || !plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_CONTINUE)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(TranslatableCaption.of("permission.no_plot_perms").toComponent(player))));
            return false;
        }
        if (!DoneFlag.isDone(plot)) {
            player.sendMessage(TranslatableCaption.of("done.done_not_done"), new TagResolver[0]);
            return false;
        }
        int size = plot.getConnectedPlots().size();
        if (!Settings.Done.COUNTS_TOWARDS_LIMIT && player.getAllowedPlots() < player.getPlotCount() + size) {
            player.sendMessage(TranslatableCaption.of("permission.cant_claim_more_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(player.getAllowedPlots()))));
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        DoneFlag plotFlag = plot.getFlagContainer().getFlag(DoneFlag.class);
        PlotFlagRemoveEvent event = this.eventDispatcher.callFlagRemove(plotFlag, plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Done flag removal"))));
            return true;
        }
        plot.removeFlag(event.getFlag());
        player.sendMessage(TranslatableCaption.of("done.done_removed"), new TagResolver[0]);
        return true;
    }
}

