/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlotUploader;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(usage="/plot download [schem | world]", command="download", aliases={"dl"}, category=CommandCategory.SCHEMATIC, requiredType=RequiredType.NONE, permission="plots.download")
public class Download
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final PlotUploader plotUploader;
    private final @NonNull SchematicHandler schematicHandler;
    private final WorldUtil worldUtil;

    @Inject
    public Download(@NonNull PlotAreaManager plotAreaManager, @NonNull PlotUploader plotUploader, @NonNull SchematicHandler schematicHandler, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.plotUploader = plotUploader;
        this.schematicHandler = schematicHandler;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        String world = player.getLocation().getWorldName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        final Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (Settings.Done.REQUIRED_FOR_DOWNLOAD && !DoneFlag.isDone(plot) && !player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DOWNLOAD)) {
            player.sendMessage(TranslatableCaption.of("done.done_not_done"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(player.getUUID()) && !player.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        if (args.length == 0 || args.length == 1 && StringMan.isEqualIgnoreCaseToAny(args[0], "sch", "schem", "schematic")) {
            if (plot.getVolume() > 2.147483647E9) {
                player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
                return false;
            }
            plot.addRunning();
            this.upload(player, plot);
        } else if (args.length == 1 && StringMan.isEqualIgnoreCaseToAny(args[0], "mcr", "world", "mca")) {
            if (!player.hasPermission(Permission.PERMISSION_DOWNLOAD_WORLD)) {
                player.sendMessage(TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_DOWNLOAD_WORLD)));
                return false;
            }
            player.sendMessage(TranslatableCaption.of("schematics.mca_file_size"), new TagResolver[0]);
            plot.addRunning();
            this.worldUtil.saveWorld(world);
            this.worldUtil.upload(plot, null, null, new RunnableVal<URL>(){

                @Override
                public void run(URL url) {
                    plot.removeRunning();
                    if (url == null) {
                        player.sendMessage(TranslatableCaption.of("web.generating_link_failed"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
                        return;
                    }
                    player.sendMessage(TranslatableCaption.of("web.generation_link_success_legacy_world"), TagResolver.resolver("url", Tag.inserting(Component.text(url.toString()))));
                }
            });
        } else {
            this.sendUsage(player);
            return false;
        }
        player.sendMessage(TranslatableCaption.of("web.generating_link"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_DOWNLOAD)) {
                completions.add("schem");
            }
            if (player.hasPermission(Permission.PERMISSION_DOWNLOAD_WORLD)) {
                completions.add("world");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_DOWNLOAD) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }

    private void upload(final PlotPlayer<?> player, final Plot plot) {
        if (Settings.Web.LEGACY_WEBINTERFACE) {
            this.schematicHandler.getCompoundTag(plot).whenComplete((compoundTag, throwable) -> this.schematicHandler.upload((CompoundTag)compoundTag, null, null, new RunnableVal<URL>(){

                @Override
                public void run(URL value) {
                    plot.removeRunning();
                    player.sendMessage(TranslatableCaption.of("web.generation_link_success"), TagResolver.builder().tag("download", Tag.preProcessParsed(value.toString())).tag("delete", Tag.preProcessParsed("Not available")).build());
                    player.sendMessage(StaticCaption.of(value.toString()), new TagResolver[0]);
                }
            }));
            return;
        }
        this.plotUploader.upload(plot).whenComplete((result, throwable) -> {
            if (throwable != null || !result.isSuccess()) {
                player.sendMessage(TranslatableCaption.of("web.generating_link_failed"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            } else {
                player.sendMessage(TranslatableCaption.of("web.generation_link_success"), TagResolver.builder().tag("download", Tag.preProcessParsed(result.getDownloadUrl())).tag("delete", Tag.preProcessParsed(result.getDeletionUrl())).build());
            }
        });
    }
}

