/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption.load;

import com.plotsquared.core.configuration.caption.load.CaptionLoader;
import com.plotsquared.core.configuration.caption.load.DefaultCaptionProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ClassLoaderCaptionProvider
implements DefaultCaptionProvider {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + ClassLoaderCaptionProvider.class.getSimpleName()));
    private final ClassLoader classLoader;
    private final Function<@NonNull Locale, @NonNull String> urlProvider;

    ClassLoaderCaptionProvider(@NonNull ClassLoader classLoader, @NonNull Function<@NonNull Locale, @NonNull String> urlProvider) {
        this.classLoader = classLoader;
        this.urlProvider = urlProvider;
    }

    @Override
    public @Nullable Map<String, String> loadDefaults(@NonNull Locale locale) {
        Map<String, String> map;
        String url = this.urlProvider.apply(locale);
        InputStream stream = this.classLoader.getResourceAsStream(url);
        if (stream == null) {
            LOGGER.info("No resource for locale '{}' found in the plugin file.Please ensure you have placed the latest version of the file messages_{}.json in the 'lang' folder.You may be able to find completed translations at https://intellectualsites.crowdin.com/plotsquared", (Object)locale, (Object)locale);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            map = CaptionLoader.loadFromReader(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Unable to load language resource", (Throwable)e);
                return null;
            }
        }
        reader.close();
        return map;
    }
}

