/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ContentType {
    private static final Map<String, ContentType> internalMap = new HashMap<String, ContentType>();
    public static final ContentType JSON = ContentType.of("application/json; charset=UTF-8");
    public static final ContentType XML = ContentType.of("application/xml");
    public static final ContentType DUMMY = ContentType.of("application/*");
    public static final ContentType STRING_UTF8 = ContentType.of("text/html; charset=UTF-8");
    private final String type;

    private ContentType(@NotNull String type) {
        this.type = type;
    }

    @NotNull
    public static ContentType of(@NotNull String type) {
        return internalMap.computeIfAbsent(Objects.requireNonNull(type, "Type may not be null").toLowerCase(), ContentType::new);
    }

    public String toString() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType mimeType = (ContentType)o;
        return Objects.equals(this.type, mimeType.type);
    }
}

