/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http.external;

import com.google.gson.Gson;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.ContentType;
import com.plotsquared.core.http.EntityMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class GsonMapper {
    @NotNull
    public static <T> GsonSerializer<T> serializer(@NotNull Class<T> clazz, @NotNull Gson gson) {
        return new GsonSerializer(clazz, gson);
    }

    @NotNull
    public static <T> GsonDeserializer<T> deserializer(@NotNull Class<T> clazz, @NotNull Gson gson) {
        return new GsonDeserializer(clazz, gson);
    }

    private static final class GsonSerializer<T>
    implements EntityMapper.EntitySerializer<T> {
        private final Class<T> clazz;
        private final Gson gson;

        private GsonSerializer(@NotNull Class<T> clazz, @NotNull Gson gson) {
            this.clazz = clazz;
            this.gson = gson;
        }

        @Override
        @NotNull
        public byte[] serialize(@NotNull T input) {
            return this.gson.toJson(input).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public ContentType getContentType() {
            return ContentType.JSON;
        }
    }

    private static final class GsonDeserializer<T>
    implements EntityMapper.EntityDeserializer<T> {
        private final Class<T> clazz;
        private final Gson gson;

        private GsonDeserializer(@NotNull Class<T> clazz, @NotNull Gson gson) {
            this.clazz = clazz;
            this.gson = gson;
        }

        @Override
        @NotNull
        public T deserialize(@Nullable ContentType contentType, @NotNull byte[] input) {
            Charset charset = contentType != null && contentType.toString().toLowerCase().contains("utf-8") ? StandardCharsets.UTF_8 : (contentType != null && contentType.toString().toLowerCase().contains("utf-16") ? StandardCharsets.UTF_16 : StandardCharsets.US_ASCII);
            return (T)this.gson.fromJson(new String(input, charset), this.clazz);
        }
    }
}

