/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag;

import com.google.common.base.Preconditions;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.plot.flag.FlagParseException;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class PlotFlag<T, F extends PlotFlag<T, F>> {
    private final T value;
    private final Caption flagCategory;
    private final Caption flagDescription;
    private final String flagName;

    protected PlotFlag(@NonNull T value, @NonNull Caption flagCategory, @NonNull Caption flagDescription) {
        this.value = Preconditions.checkNotNull(value, (Object)"flag value may not be null");
        this.flagCategory = (Caption)Preconditions.checkNotNull((Object)flagCategory, (Object)"flag category may not be null");
        this.flagDescription = (Caption)Preconditions.checkNotNull((Object)flagDescription, (Object)"flag description may not be null");
        this.flagName = PlotFlag.getFlagName(this.getClass());
    }

    public static <T, F extends PlotFlag<T, F>> String getFlagName(Class<F> flagClass) {
        StringBuilder flagName = new StringBuilder();
        char[] chars = flagClass.getSimpleName().replace("Flag", "").toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0) {
                flagName.append(Character.toLowerCase(chars[i]));
                continue;
            }
            if (Character.isUpperCase(chars[i])) {
                flagName.append('-').append(Character.toLowerCase(chars[i]));
                continue;
            }
            flagName.append(chars[i]);
        }
        return flagName.toString();
    }

    public static <T, F extends PlotFlag<T, F>> Component getFlagNameComponent(Class<F> flagClass) {
        return Component.text(PlotFlag.getFlagName(flagClass));
    }

    public final @NonNull T getValue() {
        return this.value;
    }

    public abstract F parse(@NonNull String var1) throws FlagParseException;

    public abstract F merge(@NonNull T var1);

    public abstract String toString();

    public final String getName() {
        return this.flagName;
    }

    public Caption getFlagDescription() {
        return this.flagDescription;
    }

    public Caption getFlagCategory() {
        return this.flagCategory;
    }

    public boolean isValuedPermission() {
        return true;
    }

    public abstract String getExample();

    protected abstract F flagOf(@NonNull T var1);

    public final F createFlagInstance(@NonNull T value) {
        return this.flagOf(Preconditions.checkNotNull(value));
    }

    public Collection<String> getTabCompletions() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlotFlag plotFlag = (PlotFlag)o;
        return this.value.equals(plotFlag.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

