/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.TimedFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FeedFlag
extends TimedFlag<Integer, FeedFlag> {
    public static final FeedFlag FEED_NOTHING = new FeedFlag(new TimedFlag.Timed<Integer>(0, 0));

    public FeedFlag(@NonNull TimedFlag.Timed<Integer> value) {
        super(value, 1, (Caption)TranslatableCaption.of("flags.flag_description_feed"));
    }

    @Override
    protected Integer parseValue(String input) throws FlagParseException {
        int parsed;
        try {
            parsed = Integer.parseInt(input);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, input, TranslatableCaption.of("invalid.not_a_number"), TagResolver.resolver("value", Tag.inserting(Component.text(input))));
        }
        if (parsed < 1) {
            throw new FlagParseException(this, input, TranslatableCaption.of("invalid.number_not_positive"), TagResolver.resolver("value", Tag.inserting(Component.text(parsed))));
        }
        return parsed;
    }

    @Override
    protected Integer mergeValue(Integer other) {
        return (Integer)((TimedFlag.Timed)this.getValue()).value() + other;
    }

    @Override
    public String getExample() {
        return "10 5";
    }

    @Override
    protected FeedFlag flagOf(@NonNull TimedFlag.Timed<Integer> value) {
        return new FeedFlag(value);
    }
}

