/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class NumberFlag<N extends Number, F extends PlotFlag<N, F>>
extends PlotFlag<N, F> {
    protected final N minimum;
    protected final N maximum;

    protected NumberFlag(@NonNull N value, N minimum, N maximum, @NonNull Caption flagCategory, @NonNull Caption flagDescription) {
        super(value, flagCategory, flagDescription);
        if (((Comparable)maximum).compareTo(minimum) < 0) {
            throw new IllegalArgumentException("Maximum may not be less than minimum:" + maximum + " < " + minimum);
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public F parse(@NonNull String input) throws FlagParseException {
        N parsed = this.parseNumber(input);
        if (((Comparable)parsed).compareTo(this.minimum) < 0 || ((Comparable)parsed).compareTo(this.maximum) > 0) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_integer"), new TagResolver[0]);
        }
        return this.flagOf(parsed);
    }

    protected abstract @NonNull N parseNumber(String var1) throws FlagParseException;
}

