/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotWorld;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.ScatteredPlotWorld;
import com.plotsquared.core.plot.world.StandardPlotWorld;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.google.Singleton;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class DefaultPlotAreaManager
implements PlotAreaManager {
    final PlotArea[] noPlotAreas = new PlotArea[0];
    private final Map<String, PlotWorld> plotWorlds = new HashMap<String, PlotWorld>();

    @Override
    public @NonNull PlotArea[] getAllPlotAreas() {
        HashSet<PlotArea> area = new HashSet<PlotArea>();
        for (PlotWorld world : this.plotWorlds.values()) {
            area.addAll(world.getAreas());
        }
        return area.toArray(new PlotArea[0]);
    }

    @Override
    public @Nullable PlotArea getApplicablePlotArea(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        PlotWorld world = this.plotWorlds.get(location.getWorldName());
        if (world == null) {
            return null;
        }
        return world.getArea(location);
    }

    @Override
    public void addPlotArea(@NonNull PlotArea plotArea) {
        PlotWorld world = this.plotWorlds.get(plotArea.getWorldName());
        if (world != null) {
            if (world instanceof StandardPlotWorld && world.getAreas().isEmpty()) {
                this.plotWorlds.remove(plotArea.getWorldName());
            } else {
                world.addArea(plotArea);
                return;
            }
        }
        if (plotArea.getType() != PlotAreaType.PARTIAL) {
            world = new StandardPlotWorld(plotArea.getWorldName(), plotArea);
        } else {
            world = new ScatteredPlotWorld(plotArea.getWorldName());
            world.addArea(plotArea);
        }
        this.plotWorlds.put(plotArea.getWorldName(), world);
    }

    @Override
    public void removePlotArea(@NonNull PlotArea area) {
        PlotWorld world = this.plotWorlds.get(area.getWorldName());
        if (world == null) {
            return;
        }
        if (world instanceof StandardPlotWorld) {
            this.plotWorlds.remove(world.getWorld());
        } else {
            world.removeArea(area);
            if (world.getAreas().isEmpty()) {
                this.plotWorlds.remove(world.getWorld());
            }
        }
    }

    @Override
    public PlotArea getPlotArea(@NonNull String world, @Nullable String id) {
        PlotWorld plotWorld = this.plotWorlds.get(world);
        if (plotWorld == null) {
            return null;
        }
        ArrayList<PlotArea> areas = new ArrayList<PlotArea>(plotWorld.getAreas());
        if (areas.size() == 1) {
            return (PlotArea)areas.get(0);
        }
        if (id == null) {
            return null;
        }
        for (PlotArea area : areas) {
            if (!StringMan.isEqual(id, area.getId())) continue;
            return area;
        }
        return null;
    }

    @Override
    public @Nullable PlotArea getPlotArea(@NonNull Location location) {
        return this.getApplicablePlotArea(location);
    }

    @Override
    public @NonNull PlotArea[] getPlotAreas(@NonNull String world, @Nullable CuboidRegion region) {
        PlotWorld plotWorld = this.plotWorlds.get(world);
        if (plotWorld == null) {
            return this.noPlotAreas;
        }
        if (region == null) {
            return plotWorld.getAreas().toArray(new PlotArea[0]);
        }
        return plotWorld.getAreasInRegion(region).toArray(new PlotArea[0]);
    }

    @Override
    public boolean addWorld(@NonNull String worldName) {
        PlotWorld world = this.plotWorlds.get(worldName);
        if (world != null) {
            return false;
        }
        world = new StandardPlotWorld(worldName, null);
        this.plotWorlds.put(worldName, world);
        return true;
    }

    @Override
    public void removeWorld(@NonNull String worldName) {
        this.plotWorlds.remove(worldName);
    }

    @Override
    public @NonNull String[] getAllWorlds() {
        return this.plotWorlds.keySet().toArray(new String[0]);
    }
}

