/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GridPlotWorld;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlot;
import com.plotsquared.core.plot.world.SinglePlotManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.TaskManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SinglePlotArea
extends GridPlotWorld {
    private final EventDispatcher eventDispatcher;
    private final PlotListener plotListener;
    public boolean VOID = false;

    public SinglePlotArea(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @NonNull GlobalBlockQueue globalBlockQueue) {
        super("*", null, new SingleWorldGenerator(plotAreaManager), null, null, worldConfiguration, globalBlockQueue);
        this.eventDispatcher = eventDispatcher;
        this.plotListener = plotListener;
        this.setAllowSigns(false);
        this.setDefaultHome(new BlockLoc(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public static boolean isSinglePlotWorld(String worldName) {
        int len = worldName.length();
        int separator = 0;
        block4: for (int i = 0; i < len; ++i) {
            switch (worldName.charAt(i)) {
                case '_': {
                    ++separator;
                    continue block4;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return separator == 1;
    }

    @Override
    protected @NonNull PlotManager createManager() {
        return new SinglePlotManager(this);
    }

    @Override
    public void loadConfiguration(ConfigurationSection config) {
        this.VOID = config.getBoolean("void", false);
    }

    @Override
    public void saveConfiguration(ConfigurationSection config) {
        super.saveConfiguration(config);
    }

    public void loadWorld(PlotId id) {
        File src;
        String worldName = id.toUnderscoreSeparatedString();
        if (PlotSquared.platform().worldUtil().isWorld(worldName)) {
            return;
        }
        PlotAreaBuilder builder = PlotAreaBuilder.newBuilder().plotManager("PlotSquared:single").generatorName("PlotSquared:single").plotAreaType(this.getType()).terrainType(this.getTerrain()).settingsNodesWrapper(new SettingsNodesWrapper(new ConfigurationNode[0], null)).worldName(worldName);
        File container = PlotSquared.platform().worldContainer();
        File destination = new File(container, worldName);
        File oldFile = new File(container, id.toCommaSeparatedString());
        if (oldFile.exists()) {
            oldFile.renameTo(destination);
        } else {
            oldFile = new File(container, id.toSeparatedString("."));
            if (oldFile.exists()) {
                oldFile.renameTo(destination);
            }
        }
        if (builder.plotAreaType() != PlotAreaType.NORMAL && !destination.exists() && (src = new File(container, "0_0")).exists()) {
            File levelDat;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if ((levelDat = new File(src, "level.dat")).exists()) {
                try {
                    Files.copy(levelDat.toPath(), new File(destination, levelDat.getName()).toPath(), new CopyOption[0]);
                    File data = new File(src, "data");
                    if (data.exists()) {
                        File dataDest = new File(destination, "data");
                        dataDest.mkdirs();
                        for (File file : data.listFiles()) {
                            Files.copy(file.toPath(), new File(dataDest, file.getName()).toPath(), new CopyOption[0]);
                        }
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        try {
            TaskManager.getPlatformImplementation().sync(() -> {
                String name = id.toUnderscoreSeparatedString();
                if (!PlotSquared.platform().worldUtil().isWorld(name)) {
                    PlotSquared.platform().setupUtils().setupWorld(builder);
                }
                return null;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ConfigurationNode[] getSettingNodes() {
        return new ConfigurationNode[]{new ConfigurationNode("void", this.VOID, TranslatableCaption.of("setup.singleplotarea_void_world"), ConfigurationUtil.BOOLEAN)};
    }

    @Override
    public @Nullable Plot getOwnedPlot(@NonNull Location location) {
        PlotId pid = PlotId.fromStringOrNull(location.getWorldName());
        Plot plot = pid == null ? null : (Plot)this.plots.get(pid);
        return plot == null ? null : plot.getBasePlot(false);
    }

    @Override
    public @Nullable Plot getOwnedPlotAbs(@NonNull Location location) {
        PlotId pid = PlotId.fromStringOrNull(location.getWorldName());
        return pid == null ? null : (Plot)this.plots.get(pid);
    }

    @Override
    public @Nullable Plot getPlot(@NonNull Location location) {
        PlotId pid = PlotId.fromStringOrNull(location.getWorldName());
        return pid == null ? null : this.getPlot(pid);
    }

    @Override
    public @Nullable Plot getPlotAbs(@NonNull Location location) {
        PlotId pid = PlotId.fromStringOrNull(location.getWorldName());
        return pid == null ? null : this.getPlotAbs(pid);
    }

    @Override
    public boolean addPlot(@NonNull Plot plot) {
        plot = this.adapt(plot);
        return super.addPlot(plot);
    }

    @Override
    public boolean addPlotAbs(@NonNull Plot plot) {
        plot = this.adapt(plot);
        return super.addPlotAbs(plot);
    }

    @Override
    public boolean addPlotIfAbsent(@NonNull Plot plot) {
        plot = this.adapt(plot);
        return super.addPlotIfAbsent(plot);
    }

    @Override
    public boolean allowSigns() {
        return false;
    }

    protected Plot adapt(Plot p) {
        if (p instanceof SinglePlot) {
            return p;
        }
        PlotSettings s = p.getSettings();
        FlagContainer oldContainer = p.getFlagContainer();
        p = new SinglePlot(p.getId(), p.getOwnerAbs(), p.getTrusted(), p.getMembers(), p.getDenied(), s.getAlias(), s.getPosition(), null, this, s.getMerged(), p.getTimestamp(), p.temp);
        p.getFlagContainer().addAll(oldContainer);
        return p;
    }

    @Override
    public @Nullable Plot getPlotAbs(@NonNull PlotId id) {
        Plot plot = this.getOwnedPlotAbs(id);
        if (plot == null) {
            return new SinglePlot(this, id);
        }
        return plot;
    }

    @Override
    public @Nullable Plot getPlot(@NonNull PlotId id) {
        Plot plot = this.getOwnedPlotAbs(id);
        if (plot == null) {
            return new SinglePlot(this, id);
        }
        return plot.getBasePlot(false);
    }
}

