/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.annotations.informative.NotPublic;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@NotPublic
public class BlockArrayCacheScopedQueueCoordinator
extends ZeroedDelegateScopedQueueCoordinator {
    private final BlockState[][][] blockStates;
    private final int height;
    private final int width;
    private final int length;
    private final int minY;
    private final int maxY;
    private final int scopeMinX;
    private final int scopeMinZ;
    private final int scopeMaxX;
    private final int scopeMaxZ;
    private int offsetX = 0;
    private int offsetZ = 0;

    public BlockArrayCacheScopedQueueCoordinator(Location min, Location max) {
        super(null, min, max);
        this.width = max.getX() - min.getX() + 1;
        this.length = max.getZ() - min.getZ() + 1;
        this.minY = min.getY();
        this.maxY = max.getY();
        this.height = this.maxY - this.minY + 1;
        this.scopeMinX = min.getX() & 0xF;
        this.scopeMinZ = min.getZ() & 0xF;
        this.scopeMaxX = this.scopeMinX + this.width;
        this.scopeMaxZ = this.scopeMinZ + this.length;
        this.blockStates = new BlockState[this.height][this.width][this.length];
    }

    public BlockState[][][] getBlockStates() {
        return this.blockStates;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BlockState id) {
        if ((x += this.offsetX) >= this.scopeMinX && x < this.scopeMaxX && y >= this.minY && y <= this.maxY && (z += this.offsetZ) >= this.scopeMinZ && z < this.scopeMaxZ) {
            this.blockStates[y - this.minY][x - this.scopeMinX][z - this.scopeMinZ] = id;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull Pattern pattern) {
        int rx = x + this.offsetX;
        int rz = z + this.offsetZ;
        if (rx >= this.scopeMinX && rx < this.scopeMaxX && y >= this.minY && y <= this.maxY && rz >= this.scopeMinZ && rz < this.scopeMaxZ) {
            BlockState state;
            this.blockStates[y - this.minY][rx - this.scopeMinX][rz - this.scopeMinZ] = state = pattern.applyBlock(super.getMin().getBlockVector3().add(BlockVector3.at((int)x, (int)y, (int)z))).toImmutableState();
        }
        return false;
    }

    @Override
    public @NonNull Location getMin() {
        return super.getMin().add(this.offsetX - this.scopeMinX, 0, this.offsetZ - this.scopeMinZ);
    }

    @Override
    public @NonNull Location getMax() {
        return this.getMin().add(15, 0, 15).withY(this.maxY);
    }

    @Override
    public boolean setBlock(int x, int y, int z, @NonNull BaseBlock id) {
        if ((x += this.offsetX) >= this.scopeMinX && x < this.scopeMaxX && y >= this.minY && y <= this.maxY && (z += this.offsetZ) >= this.scopeMinZ && z < this.scopeMaxZ) {
            this.blockStates[y - this.minY][x - this.scopeMinX][z - this.scopeMinZ] = id.toImmutableState();
        }
        return false;
    }

    @Override
    public @Nullable BlockState getBlock(int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= this.minY && y <= this.maxY && z >= 0 && z < this.length) {
            return this.blockStates[y - this.minY][x][z];
        }
        return null;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetZ(int offsetZ) {
        this.offsetZ = offsetZ;
    }

    @Override
    public int size() {
        return this.height * this.width * this.length;
    }

    @Override
    public boolean setBiome(int x, int z, @NonNull BiomeType biome) {
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, @NonNull BiomeType biome) {
        return false;
    }

    @Override
    public void fillBiome(BiomeType biome) {
    }

    @Override
    public boolean setTile(int x, int y, int z, @NonNull CompoundTag tag) {
        return false;
    }
}

