/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.net.AbstractDelegateOutputStream;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.YieldRunnable;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.MCEditSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicReader;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SchematicHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SchematicHandler.class.getSimpleName()));
    private static final Gson GSON = new Gson();
    public static SchematicHandler manager;
    private final WorldUtil worldUtil;
    private final ProgressSubscriberFactory subscriberFactory;
    private boolean exportAll = false;

    @Inject
    public SchematicHandler(@NonNull WorldUtil worldUtil, @NonNull ProgressSubscriberFactory subscriberFactory) {
        this.worldUtil = worldUtil;
        this.subscriberFactory = subscriberFactory;
    }

    @Deprecated(forRemoval=true, since="6.0.0")
    public static void upload(@Nullable UUID uuid, @Nullable String file, @NonNull String extension, @Nullable RunnableVal<OutputStream> writeTask, @NonNull RunnableVal<URL> whenDone) {
        URL url;
        String filename;
        String website;
        if (writeTask == null) {
            TaskManager.runTask(whenDone);
            return;
        }
        if (uuid == null) {
            uuid = UUID.randomUUID();
            website = Settings.Web.URL + "upload.php?" + uuid;
            filename = "plot." + extension;
        } else {
            website = Settings.Web.URL + "save.php?" + uuid;
            filename = file + "." + extension;
        }
        try {
            url = new URL(Settings.Web.URL + "?key=" + uuid + "&type=" + extension);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            whenDone.run();
            return;
        }
        TaskManager.runTaskAsync(() -> {
            try {
                int responseCode;
                String content;
                String boundary = Long.toHexString(System.currentTimeMillis());
                URLConnection con = new URL(website).openConnection();
                con.setDoOutput(true);
                con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                try (OutputStream output = con.getOutputStream();
                     PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), true);){
                    String CRLF = "\r\n";
                    writer.append("--").append(boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"param\"").append(CRLF);
                    writer.append("Content-Type: text/plain; charset=").append(StandardCharsets.UTF_8.displayName()).append(CRLF);
                    String param = "value";
                    writer.append(CRLF).append(param).append(CRLF).flush();
                    writer.append("--").append(boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"schematicFile\"; filename=\"").append(filename).append(String.valueOf('\"')).append(CRLF);
                    writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(filename)).append(CRLF);
                    writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                    writer.append(CRLF).flush();
                    writeTask.value = new AbstractDelegateOutputStream(output){

                        @Override
                        public void close() {
                        }
                    };
                    writeTask.run();
                    output.flush();
                    writer.append(CRLF).flush();
                    writer.append("--").append(boundary).append("--").append(CRLF).flush();
                }
                try (Scanner scanner = new Scanner(con.getInputStream()).useDelimiter("\\A");){
                    content = scanner.next().trim();
                }
                if (!content.startsWith("<")) {
                    // empty if block
                }
                if ((responseCode = ((HttpURLConnection)con).getResponseCode()) == 200) {
                    whenDone.value = url;
                }
                TaskManager.runTask(whenDone);
            }
            catch (IOException e) {
                e.printStackTrace();
                TaskManager.runTask(whenDone);
            }
        });
    }

    public boolean exportAll(Collection<Plot> collection, final File outputDir, final String namingScheme, final Runnable ifSuccess) {
        if (this.exportAll) {
            return false;
        }
        if (collection.isEmpty()) {
            return false;
        }
        this.exportAll = true;
        final ArrayList<Plot> plots = new ArrayList<Plot>(collection);
        TaskManager.runTaskAsync(new Runnable(){

            @Override
            public void run() {
                if (plots.isEmpty()) {
                    SchematicHandler.this.exportAll = false;
                    TaskManager.runTask(ifSuccess);
                    return;
                }
                Iterator i = plots.iterator();
                Plot plot = (Plot)i.next();
                i.remove();
                String owner = plot.hasOwner() ? plot.getOwnerAbs().toString() : "unknown";
                Object name = namingScheme == null ? plot.getId().getX() + ";" + plot.getId().getY() + "," + plot.getArea() + "," + owner : namingScheme.replaceAll("%id%", plot.getId().toString()).replaceAll("%idx%", "" + plot.getId().getX()).replaceAll("%idy%", "" + plot.getId().getY()).replaceAll("%world%", plot.getArea().toString());
                String directory = outputDir == null ? Settings.Paths.SCHEMATICS : outputDir.getAbsolutePath();
                2 THIS = this;
                SchematicHandler.this.getCompoundTag(plot).whenComplete((arg_0, arg_1) -> this.lambda$run$1(directory, (String)name, plot, THIS, arg_0, arg_1));
            }

            private /* synthetic */ void lambda$run$1(String directory, String name, Plot plot, Runnable THIS, CompoundTag compoundTag, Throwable throwable) {
                if (compoundTag != null) {
                    TaskManager.runTaskAsync(() -> {
                        boolean result = SchematicHandler.this.save(compoundTag, directory + File.separator + name + ".schem");
                        if (!result) {
                            LOGGER.error("Failed to save {}", (Object)plot.getId());
                        }
                        TaskManager.runTask(THIS);
                    });
                }
            }
        });
        return true;
    }

    public void paste(Schematic schematic, Plot plot, int xOffset, int yOffset, int zOffset, boolean autoHeight, PlotPlayer<?> actor, RunnableVal<Boolean> whenDone) {
        if (whenDone != null) {
            whenDone.value = false;
        }
        if (schematic == null) {
            TaskManager.runTask(whenDone);
            return;
        }
        try {
            CuboidRegion allRegion;
            int p2z;
            int p2x;
            int p1z;
            int p1x;
            PlotArea pw;
            boolean sizeMismatch;
            BlockVector3 dimension = schematic.getClipboard().getDimensions();
            int WIDTH = dimension.getX();
            int LENGTH = dimension.getZ();
            int HEIGHT = dimension.getY();
            int worldHeight = plot.getArea().getMaxGenHeight() - plot.getArea().getMinGenHeight() + 1;
            CuboidRegion region = plot.getLargestRegion();
            boolean bl = sizeMismatch = region.getMaximumPoint().getX() - region.getMinimumPoint().getX() + xOffset + 1 < WIDTH || region.getMaximumPoint().getZ() - region.getMinimumPoint().getZ() + zOffset + 1 < LENGTH || HEIGHT > worldHeight;
            if (!Settings.Schematics.PASTE_MISMATCHES && sizeMismatch) {
                actor.sendMessage(TranslatableCaption.of("schematics.schematic_size_mismatch"), new TagResolver[0]);
                TaskManager.runTask(whenDone);
                return;
            }
            Clipboard blockArrayClipboard = schematic.getClipboard();
            int y_offset_actual = autoHeight ? (HEIGHT >= worldHeight ? yOffset : ((pw = plot.getArea()) instanceof ClassicPlotWorld ? yOffset + pw.getMinBuildHeight() + ((ClassicPlotWorld)pw).PLOT_HEIGHT : yOffset + pw.getMinBuildHeight() + this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), region.getMinimumPoint().getX() + 1, region.getMinimumPoint().getZ() + 1))) : yOffset;
            if (!sizeMismatch || plot.getRegions().size() == 1) {
                p1x = region.getMinimumPoint().getX() + xOffset;
                p1z = region.getMinimumPoint().getZ() + zOffset;
                p2x = region.getMaximumPoint().getX() + xOffset;
                p2z = region.getMaximumPoint().getZ() + zOffset;
                allRegion = region;
            } else {
                Location[] corners = plot.getCorners();
                p1x = corners[0].getX() + xOffset;
                p1z = corners[0].getZ() + zOffset;
                p2x = corners[1].getX() + xOffset;
                p2z = corners[1].getZ() + zOffset;
                allRegion = new RegionIntersection(null, (Region[])plot.getRegions().toArray(new CuboidRegion[0]));
            }
            QueueCoordinator queue = plot.getArea().getQueue();
            for (int ry = 0; ry < Math.min(worldHeight, HEIGHT); ++ry) {
                int yy = y_offset_actual + ry;
                if (yy > plot.getArea().getMaxGenHeight() || yy < plot.getArea().getMinGenHeight()) continue;
                for (int rz = 0; rz < blockArrayClipboard.getDimensions().getZ(); ++rz) {
                    for (int rx = 0; rx < blockArrayClipboard.getDimensions().getX(); ++rx) {
                        int xx = p1x + rx;
                        int zz = p1z + rz;
                        if (sizeMismatch && (xx < p1x || xx > p2x || zz < p1z || zz > p2z || !allRegion.contains(BlockVector3.at((int)xx, (int)ry, (int)zz)))) continue;
                        BlockVector3 loc = BlockVector3.at((int)rx, (int)ry, (int)rz);
                        BaseBlock id = blockArrayClipboard.getFullBlock(loc);
                        queue.setBlock(xx, yy, zz, id);
                        BiomeType biome = blockArrayClipboard.getBiome(loc);
                        queue.setBiome(xx, yy, zz, biome);
                    }
                }
            }
            if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
            }
            if (whenDone != null) {
                whenDone.value = true;
                queue.setCompleteTask(whenDone);
            }
            queue.enqueue();
        }
        catch (Exception e) {
            e.printStackTrace();
            TaskManager.runTask(whenDone);
        }
    }

    public abstract boolean restoreTile(QueueCoordinator var1, CompoundTag var2, int var3, int var4, int var5);

    public Schematic getSchematic(String name) throws UnsupportedFormatException {
        File file;
        File parent = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS);
        if (!parent.exists() && !parent.mkdir()) {
            throw new RuntimeException("Could not create schematic parent directory");
        }
        if (!((String)name).endsWith(".schem") && !((String)name).endsWith(".schematic")) {
            name = (String)name + ".schem";
        }
        if (!(file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS + File.separator + (String)name)).exists()) {
            file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS + File.separator + (String)name);
        }
        return this.getSchematic(file);
    }

    public Collection<String> getSchematicNames() {
        String[] rawNames;
        File parent = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS);
        ArrayList names = new ArrayList();
        if (parent.exists() && (rawNames = parent.list((dir, name) -> name.endsWith(".schematic") || name.endsWith(".schem"))) != null) {
            List transformed = Arrays.stream(rawNames).collect(Collectors.toList());
            names.addAll(transformed);
        }
        return Collections.unmodifiableList(names);
    }

    public Schematic getSchematic(File file) throws UnsupportedFormatException {
        if (!file.exists()) {
            return null;
        }
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        if (format != null) {
            Schematic schematic;
            block11: {
                ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
                try {
                    Clipboard clip = reader.read();
                    schematic = new Schematic(clip);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                reader.close();
            }
            return schematic;
        } else {
            throw new UnsupportedFormatException("This schematic format is not recognised or supported.");
        }
        return null;
    }

    public Schematic getSchematic(@NonNull URL url) {
        try {
            ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
            InputStream inputStream = Channels.newInputStream(readableByteChannel);
            return this.getSchematic(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Schematic getSchematic(@NonNull InputStream is) {
        try {
            SpongeSchematicReader schematicReader = new SpongeSchematicReader(new NBTInputStream((InputStream)new GZIPInputStream(is)));
            Clipboard clip = schematicReader.read();
            return new Schematic(clip);
        }
        catch (IOException ignored) {
            try {
                MCEditSchematicReader schematicReader = new MCEditSchematicReader(new NBTInputStream((InputStream)new GZIPInputStream(is)));
                Clipboard clip = schematicReader.read();
                return new Schematic(clip);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    @Deprecated(forRemoval=true, since="6.11.0")
    public List<String> getSaves(UUID uuid) {
        try {
            String rawJSON;
            String website = Settings.Web.URL + "list.php?" + uuid.toString();
            URL url = new URL(website);
            URLConnection connection = new URL(url.toString()).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                rawJSON = reader.lines().collect(Collectors.joining());
            }
            JsonArray array = (JsonArray)GSON.fromJson(rawJSON, JsonArray.class);
            ArrayList<String> schematics = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                String schematic = array.get(i).getAsString();
                schematics.add(schematic);
            }
            return schematics;
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated(forRemoval=true, since="6.0.0")
    public void upload(final CompoundTag tag, UUID uuid, String file, RunnableVal<URL> whenDone) {
        if (tag == null) {
            TaskManager.runTask(whenDone);
            return;
        }
        SchematicHandler.upload(uuid, file, "schem", new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream output) {
                try (NBTOutputStream nos = new NBTOutputStream((OutputStream)new GZIPOutputStream(output, true));){
                    nos.writeNamedTag("Schematic", (Tag)tag);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }, whenDone);
    }

    public boolean save(CompoundTag tag, String path) {
        if (tag == null) {
            return false;
        }
        try {
            File tmp = FileUtils.getFile(PlotSquared.platform().getDirectory(), path);
            tmp.getParentFile().mkdirs();
            try (NBTOutputStream nbtStream = new NBTOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(tmp)));){
                nbtStream.writeNamedTag("Schematic", (Tag)tag);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void writeSchematicData(@NonNull Map<String, Tag> schematic, @NonNull Map<String, Integer> palette, @NonNull Map<String, Integer> biomePalette, @NonNull List<CompoundTag> tileEntities, @NonNull ByteArrayOutputStream buffer, @NonNull ByteArrayOutputStream biomeBuffer) {
        schematic.put("PaletteMax", (Tag)new IntTag(palette.size()));
        HashMap paletteTag = new HashMap();
        palette.forEach((key, value) -> paletteTag.put(key, new IntTag(value.intValue())));
        schematic.put("Palette", (Tag)new CompoundTag(paletteTag));
        schematic.put("BlockData", (Tag)new ByteArrayTag(buffer.toByteArray()));
        schematic.put("BlockEntities", (Tag)new ListTag(CompoundTag.class, tileEntities));
        if (biomeBuffer.size() == 0 || biomePalette.size() == 0) {
            return;
        }
        schematic.put("BiomePaletteMax", (Tag)new IntTag(biomePalette.size()));
        HashMap biomePaletteTag = new HashMap();
        biomePalette.forEach((key, value) -> biomePaletteTag.put(key, new IntTag(value.intValue())));
        schematic.put("BiomePalette", (Tag)new CompoundTag(biomePaletteTag));
        schematic.put("BiomeData", (Tag)new ByteArrayTag(biomeBuffer.toByteArray()));
    }

    private @NonNull Map<String, Tag> initSchematic(short width, short height, short length) {
        HashMap<String, Tag> schematic = new HashMap<String, Tag>();
        schematic.put("Version", (Tag)new IntTag(2));
        schematic.put("DataVersion", (Tag)new IntTag(WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataVersion()));
        HashMap<String, IntTag> metadata = new HashMap<String, IntTag>();
        metadata.put("WEOffsetX", new IntTag(0));
        metadata.put("WEOffsetY", new IntTag(0));
        metadata.put("WEOffsetZ", new IntTag(0));
        schematic.put("Metadata", (Tag)new CompoundTag(metadata));
        schematic.put("Width", (Tag)new ShortTag(width));
        schematic.put("Height", (Tag)new ShortTag(height));
        schematic.put("Length", (Tag)new ShortTag(length));
        schematic.put("Offset", (Tag)new IntArrayTag(new int[]{0, 0, 0}));
        return schematic;
    }

    public CompletableFuture<CompoundTag> getCompoundTag(@NonNull Plot plot) {
        return this.getCompoundTag(Objects.requireNonNull(plot.getWorldName()), plot.getRegions());
    }

    public @NonNull CompletableFuture<CompoundTag> getCompoundTag(@NonNull String worldName, @NonNull Set<CuboidRegion> regions) {
        final CompletableFuture<CompoundTag> completableFuture = new CompletableFuture<CompoundTag>();
        TaskManager.runTaskAsync(() -> {
            World world = this.worldUtil.getWeWorld(worldName);
            final CuboidRegion aabb = RegionUtil.getAxisAlignedBoundingBox(regions);
            aabb.setWorld(world);
            final RegionIntersection intersection = new RegionIntersection(new ArrayList(regions));
            int width = aabb.getWidth();
            int height = aabb.getHeight();
            int length = aabb.getLength();
            final boolean multipleRegions = regions.size() > 1;
            final Map<String, Tag> schematic = this.initSchematic((short)width, (short)height, (short)length);
            final HashMap palette = new HashMap();
            final HashMap biomePalette = new HashMap();
            final ArrayList tileEntities = new ArrayList();
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * height * length);
            final ByteArrayOutputStream biomeBuffer = new ByteArrayOutputStream(width * length);
            TaskManager.runTaskAsync(() -> {
                BlockVector3 minimum = aabb.getMinimumPoint();
                BlockVector3 maximum = aabb.getMaximumPoint();
                final int minX = minimum.getX();
                final int minZ = minimum.getZ();
                final int minY = minimum.getY();
                final int maxX = maximum.getX();
                final int maxZ = maximum.getZ();
                final int maxY = maximum.getY();
                YieldRunnable yTask = new YieldRunnable(){
                    int currentY;
                    int currentX;
                    int currentZ;
                    {
                        this.currentY = minY;
                        this.currentX = minX;
                        this.currentZ = minZ;
                    }

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        int lastBiome = 0;
                        while (this.currentY <= maxY) {
                            int relativeY = this.currentY - minY;
                            while (this.currentZ <= maxZ) {
                                int relativeZ = this.currentZ - minZ;
                                while (this.currentX <= maxX) {
                                    if (System.currentTimeMillis() - start > 40L) {
                                        this.yield();
                                        return;
                                    }
                                    int relativeX = this.currentX - minX;
                                    BlockVector3 point = BlockVector3.at((int)this.currentX, (int)this.currentY, (int)this.currentZ);
                                    if (multipleRegions && !intersection.contains(point)) {
                                        int blockId;
                                        String blockKey = BlockTypes.AIR.getDefaultState().getAsString();
                                        if (palette.containsKey(blockKey)) {
                                            blockId = (Integer)palette.get(blockKey);
                                        } else {
                                            blockId = palette.size();
                                            palette.put(blockKey, palette.size());
                                        }
                                        while ((blockId & 0xFFFFFF80) != 0) {
                                            buffer.write(blockId & 0x7F | 0x80);
                                            blockId >>>= 7;
                                        }
                                        buffer.write(blockId);
                                        if (relativeY <= 0) {
                                            int biomeId = lastBiome;
                                            while ((biomeId & 0xFFFFFF80) != 0) {
                                                biomeBuffer.write(biomeId & 0x7F | 0x80);
                                                biomeId >>>= 7;
                                            }
                                            biomeBuffer.write(biomeId);
                                        }
                                    } else {
                                        int blockId;
                                        String blockKey;
                                        BaseBlock block = aabb.getWorld().getFullBlock(point);
                                        if (block.getNbtData() != null) {
                                            HashMap<String, Object> values = new HashMap<String, Object>();
                                            for (Map.Entry entry : block.getNbtData().getValue().entrySet()) {
                                                values.put((String)entry.getKey(), (Tag)entry.getValue());
                                            }
                                            values.remove("x");
                                            values.remove("y");
                                            values.remove("z");
                                            values.put("Id", new StringTag(block.getNbtId()));
                                            values.remove("id");
                                            values.put("Pos", new IntArrayTag(new int[]{relativeX, relativeY, relativeZ}));
                                            tileEntities.add(new CompoundTag(values));
                                        }
                                        if (palette.containsKey(blockKey = block.toImmutableState().getAsString())) {
                                            blockId = (Integer)palette.get(blockKey);
                                        } else {
                                            blockId = palette.size();
                                            palette.put(blockKey, palette.size());
                                        }
                                        while ((blockId & 0xFFFFFF80) != 0) {
                                            buffer.write(blockId & 0x7F | 0x80);
                                            blockId >>>= 7;
                                        }
                                        buffer.write(blockId);
                                        if (relativeY <= 0) {
                                            int biomeId;
                                            BlockVector2 pt = BlockVector2.at((int)this.currentX, (int)this.currentZ);
                                            BiomeType biome = aabb.getWorld().getBiome(pt);
                                            String biomeStr = biome.getId();
                                            if (biomePalette.containsKey(biomeStr)) {
                                                biomeId = lastBiome = ((Integer)biomePalette.get(biomeStr)).intValue();
                                            } else {
                                                biomeId = lastBiome = biomePalette.size();
                                                biomePalette.put(biomeStr, biomeId);
                                            }
                                            while ((biomeId & 0xFFFFFF80) != 0) {
                                                biomeBuffer.write(biomeId & 0x7F | 0x80);
                                                biomeId >>>= 7;
                                            }
                                            biomeBuffer.write(biomeId);
                                        }
                                    }
                                    ++this.currentX;
                                }
                                this.currentX = minX;
                                ++this.currentZ;
                            }
                            this.currentZ = minZ;
                            ++this.currentY;
                        }
                        TaskManager.runTaskAsync(() -> {
                            SchematicHandler.this.writeSchematicData(schematic, palette, biomePalette, tileEntities, buffer, biomeBuffer);
                            completableFuture.complete(new CompoundTag(schematic));
                        });
                    }
                };
                yTask.run();
            });
        });
        return completableFuture;
    }

    public static class UnsupportedFormatException
    extends Exception {
        public UnsupportedFormatException(String message) {
            super(message);
        }

        public UnsupportedFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

