/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.uuid;

import com.google.common.collect.Lists;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.util.ThreadUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.ServiceError;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UUIDPipeline {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + UUIDPipeline.class.getSimpleName()));
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final Executor executor;
    private final List<UUIDService> serviceList;
    private final List<Consumer<List<UUIDMapping>>> consumerList;

    public UUIDPipeline(@NonNull Executor executor) {
        this.executor = executor;
        this.serviceList = Lists.newLinkedList();
        this.consumerList = Lists.newLinkedList();
    }

    public void registerService(@NonNull UUIDService uuidService) {
        this.serviceList.add(uuidService);
    }

    public void registerConsumer(@NonNull Consumer<@NonNull List<@NonNull UUIDMapping>> mappingConsumer) {
        this.consumerList.add(mappingConsumer);
    }

    public @NonNull List<@NonNull UUIDService> getServiceListInstance() {
        return Collections.unmodifiableList(this.serviceList);
    }

    public void consume(@NonNull List<@NonNull UUIDMapping> mappings) {
        Runnable runnable = () -> {
            for (Consumer<List<UUIDMapping>> consumer : this.consumerList) {
                consumer.accept(mappings);
            }
        };
        if (PlotSquared.get().isMainThread(Thread.currentThread())) {
            TaskManager.runTaskAsync(runnable);
        } else {
            runnable.run();
        }
    }

    public void consume(@NonNull UUIDMapping mapping) {
        this.consume(Collections.singletonList(mapping));
    }

    public void storeImmediately(@NonNull String username, @NonNull UUID uuid) {
        this.consume(new UUIDMapping(uuid, username));
    }

    public @Nullable UUID getSingle(@NonNull String username, long timeout) {
        block4: {
            ThreadUtils.catchSync("Blocking UUID retrieval from the main thread");
            try {
                List<UUIDMapping> mappings = this.getUUIDs(Collections.singletonList(username)).get(timeout, TimeUnit.MILLISECONDS);
                if (mappings.size() == 1) {
                    return mappings.get(0).uuid();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException ignored) {
                if (!Settings.DEBUG) break block4;
                LOGGER.warn("(UUID) Request for {} timed out. Rate limit.", (Object)username);
            }
        }
        return null;
    }

    public @Nullable String getSingle(@NonNull UUID uuid, long timeout) {
        block4: {
            ThreadUtils.catchSync("Blocking username retrieval from the main thread");
            try {
                List<UUIDMapping> mappings = this.getNames(Collections.singletonList(uuid)).get(timeout, TimeUnit.MILLISECONDS);
                if (mappings.size() == 1) {
                    return mappings.get(0).username();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException ignored) {
                if (!Settings.DEBUG) break block4;
                LOGGER.warn("(UUID) Request for {} timed out. Rate limit.", (Object)uuid);
            }
        }
        return null;
    }

    public void getSingle(@NonNull String username, @NonNull BiConsumer<@Nullable UUID, @Nullable Throwable> uuid) {
        this.getUUIDs(Collections.singletonList(username)).orTimeout(Settings.UUID.NON_BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS).whenComplete((uuids, throwable) -> {
            if (throwable != null) {
                uuid.accept((UUID)null, (Throwable)throwable);
            } else if (!uuids.isEmpty()) {
                uuid.accept(((UUIDMapping)uuids.get(0)).uuid(), null);
            } else {
                uuid.accept(null, null);
            }
        });
    }

    public void getSingle(@NonNull UUID uuid, @NonNull BiConsumer<@Nullable String, @Nullable Throwable> username) {
        this.getNames(Collections.singletonList(uuid)).orTimeout(Settings.UUID.NON_BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS).whenComplete((uuids, throwable) -> {
            if (throwable != null) {
                username.accept((String)null, (Throwable)throwable);
            } else if (!uuids.isEmpty()) {
                username.accept(((UUIDMapping)uuids.get(0)).username(), null);
            } else {
                username.accept(null, null);
            }
        });
    }

    public @NonNull CompletableFuture<@NonNull List<@NonNull UUIDMapping>> getNames(@NonNull Collection<@NonNull UUID> requests, long timeout) {
        return this.getNames(requests).orTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public @NonNull CompletableFuture<List<UUIDMapping>> getUUIDs(@NonNull Collection<String> requests, long timeout) {
        return this.getUUIDs(requests).orTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public @NonNull CompletableFuture<@NonNull List<@NonNull UUIDMapping>> getNames(@NonNull Collection<@NonNull UUID> requests) {
        if (requests.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<UUIDService> serviceList = this.getServiceListInstance();
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(requests.size());
        ArrayList<UUID> remainingRequests = new ArrayList<UUID>(requests);
        for (UUIDService service : serviceList) {
            if (!service.canBeSynchronous()) break;
            List<UUIDMapping> completedRequests = service.getNames(remainingRequests);
            for (UUIDMapping mapping : completedRequests) {
                remainingRequests.remove(mapping.uuid());
            }
            mappings.addAll(completedRequests);
            if (!remainingRequests.isEmpty()) continue;
            return CompletableFuture.completedFuture(mappings);
        }
        return CompletableFuture.supplyAsync(() -> {
            for (UUIDService service : serviceList) {
                List<UUIDMapping> completedRequests = service.getNames(remainingRequests);
                for (UUIDMapping mapping : completedRequests) {
                    remainingRequests.remove(mapping.uuid());
                }
                mappings.addAll(completedRequests);
                if (!remainingRequests.isEmpty()) continue;
                break;
            }
            if (mappings.size() == requests.size()) {
                this.consume(mappings);
                return mappings;
            }
            if (Settings.DEBUG) {
                LOGGER.info("(UUID) Failed to find all usernames");
            }
            if (Settings.UUID.UNKNOWN_AS_DEFAULT) {
                for (UUID uuid : remainingRequests) {
                    mappings.add(new UUIDMapping(uuid, MINI_MESSAGE.escapeTags(TranslatableCaption.of("info.unknown").getComponent(ConsolePlayer.getConsole()))));
                }
                return mappings;
            }
            throw new ServiceError("End of pipeline");
        }, this.executor);
    }

    public @NonNull CompletableFuture<@NonNull List<@NonNull UUIDMapping>> getUUIDs(@NonNull Collection<@NonNull String> requests) {
        if (requests.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<UUIDService> serviceList = this.getServiceListInstance();
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(requests.size());
        ArrayList<String> remainingRequests = new ArrayList<String>(requests);
        for (UUIDService service : serviceList) {
            if (!service.canBeSynchronous()) break;
            List<UUIDMapping> completedRequests = service.getUUIDs(remainingRequests);
            for (UUIDMapping mapping : completedRequests) {
                remainingRequests.remove(mapping.username());
            }
            mappings.addAll(completedRequests);
            if (!remainingRequests.isEmpty()) continue;
            return CompletableFuture.completedFuture(mappings);
        }
        return CompletableFuture.supplyAsync(() -> {
            for (UUIDService service : serviceList) {
                List<UUIDMapping> completedRequests = service.getUUIDs(remainingRequests);
                for (UUIDMapping mapping : completedRequests) {
                    remainingRequests.remove(mapping.username());
                }
                mappings.addAll(completedRequests);
                if (!remainingRequests.isEmpty()) continue;
                break;
            }
            if (mappings.size() == requests.size()) {
                this.consume(mappings);
                return mappings;
            }
            if (Settings.DEBUG) {
                LOGGER.info("(UUID) Failed to find all UUIDs");
            }
            throw new ServiceError("End of pipeline");
        }, this.executor);
    }

    public final @NonNull Collection<@NonNull UUIDMapping> getAllImmediately() {
        LinkedHashSet<UUIDMapping> mappings = new LinkedHashSet<UUIDMapping>();
        for (UUIDService service : this.getServiceListInstance()) {
            mappings.addAll(service.getImmediately());
        }
        return mappings;
    }

    public final @Nullable UUIDMapping getImmediately(@NonNull Object object) {
        for (UUIDService uuidService : this.getServiceListInstance()) {
            UUIDMapping mapping = uuidService.getImmediately(object);
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }
}

