/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Scope;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.spi.ScopeBinding;

final class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command) {
        ScopeBinding existing;
        Scope scope = (Scope)Preconditions.checkNotNull((Object)command.getScope(), (Object)"scope");
        Class annotationType = (Class)Preconditions.checkNotNull(command.getAnnotationType(), (Object)"annotation type");
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.missingScopeAnnotation(annotationType);
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.missingRuntimeRetention(annotationType);
        }
        if ((existing = this.injector.getBindingData().getScopeBinding(annotationType)) != null) {
            if (!scope.equals(existing.getScope())) {
                this.errors.duplicateScopes(existing, annotationType, scope);
            }
        } else {
            this.injector.getBindingData().putScopeBinding(annotationType, command);
        }
        return true;
    }
}

