/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.ModuleAnnotatedMethodScanner;

public final class ModuleAnnotatedMethodScannerBinding
implements Element {
    private final Object source;
    private final ModuleAnnotatedMethodScanner scanner;

    public ModuleAnnotatedMethodScannerBinding(Object source, ModuleAnnotatedMethodScanner scanner) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.scanner = (ModuleAnnotatedMethodScanner)Preconditions.checkNotNull((Object)scanner, (Object)"scanner");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public ModuleAnnotatedMethodScanner getScanner() {
        return this.scanner;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).scanModulesForAnnotatedMethods(this.scanner);
    }

    public String toString() {
        return this.scanner + " which scans for " + this.scanner.annotationClasses() + " (bound at " + Errors.convert(this.source) + ")";
    }
}

