/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.InjectionPoint;
import java.util.Set;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof StaticInjectionRequest && ((StaticInjectionRequest)obj).source.equals(this.source) && ((StaticInjectionRequest)obj).type.equals(this.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.type});
    }
}

