/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.helpmenu.HelpMenu;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(command="help", aliases={"?"}, category=CommandCategory.INFO, usage="help [category | #]", permission="plots.use")
public class Help
extends Command {
    public Help(Command parent) {
        super(parent, true);
    }

    @Override
    public boolean canExecute(PlotPlayer<?> player, boolean message) {
        return true;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        switch (args.length) {
            case 0: {
                return this.displayHelp(player, null, 0);
            }
            case 1: {
                if (MathMan.isInteger(args[0])) {
                    try {
                        return this.displayHelp(player, null, Integer.parseInt(args[0]));
                    }
                    catch (NumberFormatException ignored) {
                        return this.displayHelp(player, null, 1);
                    }
                }
                return this.displayHelp(player, args[0], 1);
            }
            case 2: {
                if (MathMan.isInteger(args[1])) {
                    try {
                        return this.displayHelp(player, args[0], Integer.parseInt(args[1]));
                    }
                    catch (NumberFormatException ignored) {
                        return this.displayHelp(player, args[0], 1);
                    }
                }
                return CompletableFuture.completedFuture(false);
            }
        }
        this.sendUsage(player);
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<Boolean> displayHelp(PlotPlayer<?> player, String catRaw, int page) {
        return CompletableFuture.supplyAsync(() -> {
            String cat = catRaw;
            CommandCategory catEnum = null;
            if (cat != null && !"all".equalsIgnoreCase(cat)) {
                for (CommandCategory c : CommandCategory.values()) {
                    if (!StringMan.isEqualIgnoreCaseToAny(cat, c.name(), c.toString())) continue;
                    catEnum = c;
                    cat = c.name();
                    break;
                }
                if (catEnum == null) {
                    cat = null;
                }
            }
            if (cat == null && page == 0) {
                TextComponent.Builder builder = Component.text();
                builder.append(MINI_MESSAGE.parse(TranslatableCaption.of("help.help_header").getComponent(player)));
                for (CommandCategory c : CommandCategory.values()) {
                    if (!c.canAccess(player)) continue;
                    ((TextComponent.Builder)builder.append((Component)Component.newline())).append(MINI_MESSAGE.parse(TranslatableCaption.of("help.help_info_item").getComponent(player), Template.of("command", "/plot help"), Template.of("category", c.name().toLowerCase()), Template.of("category_desc", c.getComponent(player))));
                }
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append(MINI_MESSAGE.parse(TranslatableCaption.of("help.help_info_item").getComponent(player), Template.of("command", "/plot help"), Template.of("category", "all"), Template.of("category_desc", "Display all commands")));
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append(MINI_MESSAGE.parse(TranslatableCaption.of("help.help_footer").getComponent(player)));
                player.sendMessage(StaticCaption.of((String)MINI_MESSAGE.serialize(builder.asComponent())), new Template[0]);
                return true;
            }
            new HelpMenu(player).setCategory(catEnum).getCommands().generateMaxPages().generatePage(page - 1, this.getParent().toString(), player).render();
            return true;
        });
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        String argument = args[0].toLowerCase(Locale.ENGLISH);
        ArrayList<Command> result = new ArrayList<Command>();
        for (CommandCategory category : CommandCategory.values()) {
            String name;
            if (!category.canAccess(player) || !(name = category.name().toLowerCase()).startsWith(argument)) continue;
            result.add(new Command(null, false, name, "", RequiredType.NONE, null){});
        }
        if ("all".startsWith(argument)) {
            result.add(new Command(null, false, "all", "", RequiredType.NONE, null){});
        }
        return result;
    }
}

