/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import com.plotsquared.core.util.StringMan;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlotLoc {
    private final int x;
    private final int y;
    private final int z;

    public PlotLoc(int x, int z) {
        this(x, -1, z);
    }

    public PlotLoc(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static @Nullable PlotLoc fromString(String input) {
        if (input == null || "side".equalsIgnoreCase(input)) {
            return null;
        }
        if (StringMan.isEqualIgnoreCaseToAny(input, "center", "middle", "centre")) {
            return new PlotLoc(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        try {
            String[] split = input.split(",");
            if (split.length == 2) {
                return new PlotLoc(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
            }
            if (split.length == 3) {
                return new PlotLoc(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            }
            throw new IllegalArgumentException(String.format("Unable to deserialize: %s", input));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getX();
        result = 31 * result + this.getY();
        result = 31 * result + this.getZ();
        return result;
    }

    public String toString() {
        if (this.getY() == -1) {
            return String.format("%d,%d", this.x, this.z);
        }
        return String.format("%d,%d,%d", this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlotLoc other = (PlotLoc)obj;
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
    }
}

