/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.util.InventoryUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlotInventory {
    private final PlotPlayer<?> player;
    private final int lines;
    private final PlotItemStack[] items;
    private final InventoryUtil inventoryUtil;
    private String title;
    private boolean open = false;

    public PlotInventory(@NonNull InventoryUtil inventoryUtil, PlotPlayer<?> player, int lines, String name) {
        this.lines = lines;
        this.title = name == null ? "" : name;
        this.player = player;
        this.items = new PlotItemStack[lines * 9];
        this.inventoryUtil = inventoryUtil;
    }

    public static boolean hasPlotInventoryOpen(@NonNull PlotPlayer<?> plotPlayer) {
        return PlotInventory.getOpenPlotInventory(plotPlayer) != null;
    }

    public static PlotInventory getOpenPlotInventory(@NonNull PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<PlotInventory> inventoryAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_INVENTORY);){
            PlotInventory plotInventory = inventoryAccess.get().orElse(null);
            return plotInventory;
        }
    }

    public static void setPlotInventoryOpen(@NonNull PlotPlayer<?> plotPlayer, @NonNull PlotInventory plotInventory) {
        try (MetaDataAccess<PlotInventory> inventoryAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_INVENTORY);){
            inventoryAccess.set(plotInventory);
        }
    }

    public static void removePlotInventoryOpen(@NonNull PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<PlotInventory> inventoryAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_INVENTORY);){
            inventoryAccess.remove();
        }
    }

    public boolean onClick(int index) {
        return true;
    }

    public void openInventory() {
        if (this.title == null) {
            return;
        }
        if (!PlotInventory.hasPlotInventoryOpen(this.getPlayer())) {
            this.open = true;
            PlotInventory.setPlotInventoryOpen(this.getPlayer(), this);
            this.inventoryUtil.open(this);
        }
    }

    public void close() {
        if (this.title == null) {
            return;
        }
        PlotInventory.removePlotInventoryOpen(this.getPlayer());
        this.inventoryUtil.close(this);
        this.open = false;
    }

    public void setItem(int index, PlotItemStack item) {
        this.setItemChecked(index, item);
    }

    public boolean setItemChecked(int index, PlotItemStack item) {
        if (!this.inventoryUtil.setItemChecked(this, index, item)) {
            return false;
        }
        this.items[index] = item;
        return true;
    }

    public PlotItemStack getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            return null;
        }
        return this.items[index];
    }

    public PlotItemStack[] getItems() {
        return this.items;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        boolean tmp = this.open;
        this.close();
        this.title = title;
        if (tmp) {
            this.openInventory();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public PlotPlayer<?> getPlayer() {
        return this.player;
    }

    public int getLines() {
        return this.lines;
    }
}

