/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.manager;

import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.netty.channel.InjectionFactory;
import com.comphenix.protocol.injector.netty.manager.NetworkManagerInjector;
import com.comphenix.protocol.injector.temporary.TemporaryPlayerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

final class InjectionChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final ReportType CANNOT_INJECT_CHANNEL = new ReportType("Unable to inject incoming channel %s.");
    private final InjectionFactory factory;
    private final NetworkManagerInjector listener;
    private final TemporaryPlayerFactory playerFactory;

    public InjectionChannelInboundHandler(InjectionFactory factory, NetworkManagerInjector listener, TemporaryPlayerFactory playerFactory) {
        this.factory = factory;
        this.listener = listener;
        this.playerFactory = playerFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
        if (!this.factory.isClosed()) {
            try {
                this.factory.fromChannel(ctx.channel(), this.listener, this.playerFactory).inject();
            }
            catch (Exception exception) {
                this.listener.getReporter().reportDetailed((Object)this, Report.newBuilder(CANNOT_INJECT_CHANNEL).messageParam(ctx.channel()).error(exception).build());
            }
        }
        ctx.channel().pipeline().remove((ChannelHandler)this);
    }

    public boolean isSharable() {
        return true;
    }
}

