/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.manager;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

final class ListeningList
implements List<Object> {
    private final List<Object> original;
    private final ChannelHandler channelHandler;

    public ListeningList(List<Object> original, ChannelHandler channelHandler) {
        this.original = original;
        this.channelHandler = channelHandler;
        original.forEach(this::processInsert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.contains(o);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.original.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(Consumer<? super Object> action) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.original.forEach(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object o) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.processInsert(o);
            return this.original.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Object element) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.processInsert(element);
            this.original.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<?> c) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            c.forEach(this::processInsert);
            return this.original.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<?> c) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            c.forEach(this::processInsert);
            return this.original.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object set(int index, Object element) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.processInsert(element);
            Object prev = this.original.set(index, element);
            this.processRemove(prev);
            return prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            if (this.original.remove(o)) {
                this.processRemove(o);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(int index) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            Object removed = this.original.remove(index);
            this.processRemove(removed);
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.lastIndexOf(o);
        }
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.original.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.original.listIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.subList(fromIndex, toIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            c.forEach((? super T element) -> {
                if (this.original.contains(element)) {
                    this.processRemove(element);
                }
            });
            return this.original.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super Object> filter) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.removeIf((? super E object) -> {
                boolean shouldRemove = filter.test(object);
                if (shouldRemove) {
                    this.processRemove(object);
                }
                return shouldRemove;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(UnaryOperator<Object> operator) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.original.replaceAll(value -> {
                Object newValue = operator.apply(value);
                if (newValue != value) {
                    this.processRemove(value);
                    this.processInsert(newValue);
                }
                return newValue;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super Object> c) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.original.sort(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            this.original.forEach(this::processRemove);
            this.original.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(int index) {
        ListeningList listeningList = this;
        synchronized (listeningList) {
            return this.original.get(index);
        }
    }

    private void processInsert(Object element) {
        if (element instanceof ChannelFuture) {
            Channel channel = ((ChannelFuture)element).channel();
            channel.eventLoop().execute(() -> channel.pipeline().addFirst(new ChannelHandler[]{this.channelHandler}));
        }
    }

    private void processRemove(Object element) {
        if (element instanceof ChannelFuture) {
            Channel channel = ((ChannelFuture)element).channel();
            channel.eventLoop().execute(() -> {
                try {
                    channel.pipeline().remove(this.channelHandler);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            });
        }
    }

    public List<Object> getOriginal() {
        return this.original;
    }

    public void unProcessAll() {
        this.original.forEach(this::processRemove);
    }
}

