/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.protocol.reflect.StructureModifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class NameProperty {
    private static final Map<Class<?>, StructureModifier<String>> MODIFIERS = new ConcurrentHashMap();

    public abstract String getName();

    public abstract void setName(String var1);

    private static StructureModifier<String> getModifier(Class<?> baseClass) {
        StructureModifier<String> modifier = MODIFIERS.get(baseClass);
        if (modifier == null) {
            modifier = new StructureModifier(baseClass, Object.class, false).withType(String.class);
            MODIFIERS.put(baseClass, modifier);
        }
        return modifier;
    }

    public static boolean hasStringIndex(Class<?> baseClass, int index) {
        if (index < 0) {
            return false;
        }
        return index < NameProperty.getModifier(baseClass).size();
    }

    public static NameProperty fromStringIndex(Class<?> baseClass, Object target, final int index) {
        final StructureModifier<String> modifier = NameProperty.getModifier(baseClass).withTarget(target);
        return new NameProperty(){

            @Override
            public String getName() {
                return (String)modifier.read(index);
            }

            @Override
            public void setName(String name) {
                modifier.write(index, name);
            }
        };
    }

    public static NameProperty fromBean() {
        return new NameProperty(){
            private String name;

            @Override
            public void setName(String name) {
                this.name = name;
            }

            @Override
            public String getName() {
                return this.name;
            }
        };
    }
}

