/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray;

import com.comphenix.protocol.ProtocolLibrary;
import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.google.common.collect.MapMaker;
import com.vanillage.raytraceantixray.antixray.ChunkPacketBlockControllerAntiXray;
import com.vanillage.raytraceantixray.commands.RayTraceAntiXrayTabExecutor;
import com.vanillage.raytraceantixray.data.ChunkBlocks;
import com.vanillage.raytraceantixray.data.PlayerData;
import com.vanillage.raytraceantixray.data.VectorialLocation;
import com.vanillage.raytraceantixray.listeners.PacketListener;
import com.vanillage.raytraceantixray.listeners.PlayerListener;
import com.vanillage.raytraceantixray.listeners.WorldListener;
import com.vanillage.raytraceantixray.tasks.RayTraceTimerTask;
import com.vanillage.raytraceantixray.tasks.UpdateBukkitRunnable;
import io.papermc.paper.configuration.type.EngineMode;
import java.io.File;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class RayTraceAntiXray
extends JavaPlugin {
    private volatile boolean running = false;
    private volatile boolean timingsEnabled = false;
    private final Map<ClientboundLevelChunkWithLightPacket, ChunkBlocks> packetChunkBlocksCache = new MapMaker().weakKeys().makeMap();
    private final Map<UUID, PlayerData> playerData = new ConcurrentHashMap<UUID, PlayerData>();
    private ExecutorService executorService;
    private Timer timer;

    public void onEnable() {
        if (!new File(this.getDataFolder(), "README.txt").exists()) {
            this.saveResource("README.txt", false);
        }
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.running = true;
        this.executorService = Executors.newFixedThreadPool(Math.max(this.getConfig().getInt("settings.anti-xray.ray-trace-threads"), 1));
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new RayTraceTimerTask(this), 0L, Math.max(this.getConfig().getLong("settings.anti-xray.ms-per-ray-trace-tick"), 1L));
        new UpdateBukkitRunnable(this).runTaskTimer((Plugin)this, 0L, Math.max(this.getConfig().getLong("settings.anti-xray.update-ticks"), 1L));
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        ProtocolLibrary.getProtocolManager().addPacketListener((com.comphenix.protocol.events.PacketListener)new PacketListener(this));
        this.getCommand("raytraceantixray").setExecutor((CommandExecutor)new RayTraceAntiXrayTabExecutor(this));
        this.getLogger().info(this.getDescription().getFullName() + " enabled");
    }

    public void onDisable() {
        ProtocolLibrary.getProtocolManager().removePacketListeners((Plugin)this);
        this.running = false;
        this.timer.cancel();
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        this.packetChunkBlocksCache.clear();
        this.playerData.clear();
        this.getLogger().info(this.getDescription().getFullName() + " disabled");
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isTimingsEnabled() {
        return this.timingsEnabled;
    }

    public void setTimingsEnabled(boolean timingsEnabled) {
        this.timingsEnabled = timingsEnabled;
    }

    public Map<ClientboundLevelChunkWithLightPacket, ChunkBlocks> getPacketChunkBlocksCache() {
        return this.packetChunkBlocksCache;
    }

    public Map<UUID, PlayerData> getPlayerData() {
        return this.playerData;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean isEnabled(World world) {
        return ((CraftWorld)world).getHandle().paperConfig().anticheat.antiXray.enabled && ((CraftWorld)world).getHandle().paperConfig().anticheat.antiXray.engineMode == EngineMode.HIDE && this.getConfig().getBoolean("world-settings." + world.getName() + ".anti-xray.ray-trace", this.getConfig().getBoolean("world-settings.default.anti-xray.ray-trace"));
    }

    public VectorialLocation[] getLocations(Entity entity, VectorialLocation location) {
        ChunkPacketBlockController chunkPacketBlockController = ((CraftWorld)location.getWorld()).getHandle().chunkPacketBlockController;
        if (chunkPacketBlockController instanceof ChunkPacketBlockControllerAntiXray && ((ChunkPacketBlockControllerAntiXray)chunkPacketBlockController).rayTraceThirdPerson) {
            VectorialLocation thirdPersonBackLocation = new VectorialLocation(location.getWorld(), location.getVector().clone(), location.getDirection());
            VectorialLocation thirdPersonFrontLocation = new VectorialLocation(location);
            thirdPersonFrontLocation.getDirection().multiply(-1.0);
            return new VectorialLocation[]{location, this.move(entity, thirdPersonBackLocation), this.move(entity, thirdPersonFrontLocation)};
        }
        return new VectorialLocation[]{location};
    }

    private VectorialLocation move(Entity entity, VectorialLocation location) {
        location.getVector().subtract(location.getDirection().clone().multiply(this.getMaxZoom(entity, location, 4.0)));
        return location;
    }

    private double getMaxZoom(Entity entity, VectorialLocation location, double maxZoom) {
        Vector vector = location.getVector();
        Vector direction = location.getDirection();
        Vec3D position = new Vec3D(vector.getX(), vector.getY(), vector.getZ());
        for (int i = 0; i < 8; ++i) {
            double zoom;
            float edgeX = (i & 1) * 2 - 1;
            float edgeY = (i >> 1 & 1) * 2 - 1;
            float edgeZ = (i >> 2 & 1) * 2 - 1;
            Vec3D edge = position.b((double)(edgeX *= 0.1f), (double)(edgeY *= 0.1f), (double)(edgeZ *= 0.1f));
            Vec3D edgeMoved = new Vec3D(position.c - direction.getX() * maxZoom + (double)edgeX, position.d - direction.getY() * maxZoom + (double)edgeY, position.e - direction.getZ() * maxZoom + (double)edgeZ);
            MovingObjectPositionBlock result = ((CraftWorld)location.getWorld()).getHandle().a(new RayTrace(edge, edgeMoved, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, ((CraftEntity)entity).getHandle()));
            if (result.c() == MovingObjectPosition.EnumMovingObjectType.a || !((zoom = result.e().f(position)) < maxZoom)) continue;
            maxZoom = zoom;
        }
        return maxZoom;
    }
}

